/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.UserComplexType;
import java.util.Collection;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.z.IntHashSet;

public class ElementParticle
extends Particle {
    public ElementParticle(EnterpriseConfiguration config, SourceLocator locator) {
        this.setMinOccurs(1);
        this.setMaxOccurs(1);
        this.setLocator(locator);
        this.setConfiguration(config);
        this.symbolSpace = 801;
    }

    public ElementParticle copy() {
        ElementParticle p = new ElementParticle(this.getConfiguration(), null);
        p.setTargetComponentName(this.getTargetComponentName());
        p.setReference((ElementDecl)this.target);
        p.setMinOccurs(this.getMinOccurs());
        p.setMaxOccurs(this.getMaxOccurs());
        return p;
    }

    public String getDisplayName() {
        return this.getTargetComponentName().getDisplayName();
    }

    public String getNamespaceURI() {
        return this.getTargetComponentName().getURI();
    }

    public String getName() {
        return this.getTargetComponentName().getLocalPart();
    }

    public ElementDecl getDeclaration() throws MissingComponentException {
        return (ElementDecl)this.getTarget();
    }

    public void setReference(ElementDecl declaration) {
        this.setTargetComponentName(declaration.getComponentName());
        this.setTarget(declaration);
    }

    @Override
    public boolean isEmptiable() {
        return this.getMinOccurs() == 0;
    }

    @Override
    public boolean isPointless(ModelGroup container) {
        return false;
    }

    @Override
    public void lookForCycles(Stack references, SchemaCompiler compiler) throws SchemaException, MissingComponentException {
        this.tryToResolve(compiler);
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        if (this.getFixupStatus() == SchemaComponent.ValidationStatus.UNVALIDATED) {
            this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATING);
            ElementDecl decl = (ElementDecl)PreparedSchema.validateReference(this, compiler, false);
            if (decl == null) {
                this.setFixupStatus(SchemaComponent.ValidationStatus.INVALID);
                return false;
            }
            result = decl.fixup(compiler);
        }
        this.setFixupStatus(SchemaComponent.ValidationStatus.VALIDATED);
        return result;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        switch (this.getValidationStatus()) {
            case VALIDATED: {
                return true;
            }
            case INVALID: 
            case INCOMPLETE: {
                return false;
            }
            case VALIDATING: {
                return true;
            }
        }
        if (!this.isResolved()) {
            this.tryToResolve(compiler);
            if (!this.isResolved()) {
                this.setValidationStatus(SchemaComponent.ValidationStatus.INCOMPLETE);
                return false;
            }
        }
        this.setValidationStatus(SchemaComponent.ValidationStatus.VALIDATING);
        boolean result = this.getDeclaration().validate(compiler);
        this.setValidationStatus(result ? SchemaComponent.ValidationStatus.VALIDATED : SchemaComponent.ValidationStatus.INVALID);
        return result;
    }

    @Override
    public void compile(SchemaCompiler compiler) throws SchemaException {
        if (this.getValidationStatus() != SchemaComponent.ValidationStatus.VALIDATED) {
            return;
        }
        SchemaType type = this.getDeclaration().getType();
        if (type instanceof UserComplexType) {
            UserComplexType complexType = (UserComplexType)type;
            complexType.compile(compiler);
        }
    }

    @Override
    public Term getTerm() throws MissingComponentException {
        return this.getDeclaration();
    }

    @Override
    public SchemaType getElementParticleType(int elementFingerprint) {
        try {
            ElementDecl decl = (ElementDecl)this.getTarget();
            if (elementFingerprint == this.getTargetFingerprint()) {
                return decl.getType();
            }
            Collection<ElementDecl> subsGroup = decl.getSubstitutionGroupMembers();
            for (ElementDecl mem : subsGroup) {
                if (mem.getFingerprint() != elementFingerprint) continue;
                return mem.getType();
            }
        }
        catch (MissingComponentException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return null;
    }

    @Override
    public int getElementParticleCardinality(int elementName) throws MissingComponentException {
        if (elementName == this.getTargetFingerprint()) {
            return Particle.computeParticleCardinality(this.getMinOccurs(), this.getMaxOccurs());
        }
        ElementDecl decl = (ElementDecl)this.getTarget();
        Collection<ElementDecl> subsGroup = decl.getSubstitutionGroupMembers();
        for (ElementDecl mem : subsGroup) {
            if (mem.getFingerprint() != elementName) continue;
            return Particle.computeParticleCardinality(this.getMinOccurs(), this.getMaxOccurs());
        }
        return 8192;
    }

    @Override
    public boolean containsElementWildcard() {
        return false;
    }

    @Override
    public void gatherAllPermittedElements(IntHashSet result, boolean ignoreWildcards) throws MissingComponentException {
        ElementDecl decl = (ElementDecl)this.getTarget();
        result.add(decl.getFingerprint());
        Collection<ElementDecl> subsGroup = decl.getSubstitutionGroupMembers();
        for (ElementDecl mem : subsGroup) {
            result.add(mem.getFingerprint());
        }
    }

    public String toString() {
        return "ElementParticle " + this.getName();
    }

    @Override
    public void serializeParticle(SchemaModelSerializer serializer) throws XPathException, MissingComponentException {
        serializer.startElement("elementParticle");
        serializer.emitAttribute("minOccurs", "" + this.getMinOccurs());
        serializer.emitAttribute("maxOccurs", this.getMaxOccurs() < 0 ? "unbounded" : "" + this.getMaxOccurs());
        serializer.emitAttribute("ref", serializer.getId(this.getTarget(), false));
        serializer.endElement();
    }
}

