/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.ValueConstraint;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDComplexType;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class XSDAttribute
extends SchemaElement {
    private AttributeDecl attributeDecl = null;
    private AttributeUse attributeUse = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean typeSpecified = false;
    private boolean isReference = false;

    @Override
    public void prepareAttributes() throws SchemaException {
        String inheritAtt;
        ValueConstraint vc;
        String localTargetNamespace;
        String[] allowed;
        AttributeCollection atts = this.getAttributeList();
        if (this.isTopLevel()) {
            allowed = new String[]{"default", "fixed", "id", "inheritable", "name", "type"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "name");
        } else {
            allowed = new String[]{"default", "fixed", "form", "id", "inheritable", "name", "ref", "targetNamespace", "type", "use"};
            this.allowAttributes(atts, allowed);
        }
        this.isReference = atts.getValue("", "ref") != null;
        String form = atts.getValue("", "form");
        if (form != null) {
            if (this.isReference) {
                this.mutuallyExclusiveAttributes("form", "ref");
            }
            if (!form.equals("qualified") && !form.equals("unqualified")) {
                this.invalidAttributeValue("form", form, "Must be 'qualified' or 'unqualified'");
                form = "qualified";
            }
        } else if (this.isTopLevel()) {
            form = "qualified";
        } else {
            form = this.getXSDSchema().getAttributeFormDefault();
            if (form == null) {
                form = "unqualified";
            }
        }
        if ((localTargetNamespace = atts.getValue("", "targetNamespace")) != null) {
            if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
                this.error("The targetNamespace cannot be defined locally unless XSD 1.1 is enabled");
            }
            if (atts.getValue("", "name") == null) {
                this.error("If there is no @name then there must be no @targetNamespace");
            }
            this.checkMutuallyExclusiveAttributes("targetNamespace", "form");
        }
        String attValue = atts.getValue("", "name");
        StructuredQName nc = null;
        if (attValue != null) {
            this.attributeDecl = new AttributeDecl((EnterpriseConfiguration)this.getConfiguration(), this.isTopLevel());
            this.attributeDecl.setLocator(this);
            if (attValue.equals("xmlns")) {
                this.error("The attribute name 'xmlns' is reserved");
            }
            if (atts.getValue("", "ref") != null) {
                this.mutuallyExclusiveAttributes("name", "ref");
                nc = StandardNames.SQ_XS_INVALID_NAME;
            } else {
                try {
                    if (localTargetNamespace != null || "qualified".equals(form)) {
                        if (this.getXSDSchema().getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                            this.error("Attributes cannot be declared in the 'xsi:' namespace");
                        }
                        nc = this.getComponentName(attValue, 1);
                    } else {
                        nc = this.getComponentName(attValue, 2);
                    }
                    this.attributeDecl.setAttributeName(nc);
                }
                catch (SchemaException err) {
                    this.error(err.getMessage());
                    nc = StandardNames.SQ_XS_INVALID_NAME;
                }
            }
            this.attributeDecl.setAttributeName(nc);
            if (!this.isTopLevel()) {
                this.attributeUse = new AttributeUse((EnterpriseConfiguration)this.getConfiguration());
                this.attributeUse.setTargetComponentName(this.attributeDecl.getComponentName());
                this.attributeUse.setTarget(this.attributeDecl);
                this.attributeUse.setLocator(this);
            }
        }
        if ((attValue = atts.getValue("", "ref")) != null) {
            this.attributeUse = new AttributeUse((EnterpriseConfiguration)this.getConfiguration());
            this.attributeUse.setLocator(this);
            try {
                nc = this.getComponentName(attValue, 0);
                if (nc.hasURI("http://www.w3.org/2001/XMLSchema-instance")) {
                    this.getConfiguration().addSchemaForBuiltInNamespace("http://www.w3.org/2001/XMLSchema-instance");
                }
            }
            catch (SchemaException err) {
                nc = StandardNames.SQ_XS_INVALID_NAME;
                this.error(err.getMessage());
            }
            this.attributeUse.setTargetComponentName(nc);
        }
        if ((attValue = atts.getValue("", "default")) != null && !nc.hasURI("http://www.w3.org/2001/XMLSchema-instance")) {
            vc = new ValueConstraint(ValueConstraint.Variety.DEFAULT, attValue);
            if (this.attributeUse != null) {
                this.attributeUse.setValueConstraint(vc);
            } else if (this.attributeDecl != null) {
                this.attributeDecl.setValueConstraint(vc);
            }
        }
        this.processId();
        attValue = atts.getValue("", "fixed");
        if (attValue != null) {
            if (atts.getValue("", "default") != null && !nc.hasURI("http://www.w3.org/2001/XMLSchema-instance")) {
                this.mutuallyExclusiveAttributes("fixed", "default");
            }
            vc = new ValueConstraint(ValueConstraint.Variety.FIXED, attValue);
            if (this.attributeUse != null) {
                this.attributeUse.setValueConstraint(vc);
            } else if (this.attributeDecl != null) {
                this.attributeDecl.setValueConstraint(vc);
            }
        }
        attValue = atts.getValue("", "type");
        int typeFingerprint = -1;
        if (attValue == null) {
            if (this.attributeDecl != null) {
                this.attributeDecl.setSimpleType(AnySimpleType.getInstance());
            }
        } else {
            this.typeSpecified = true;
            if (this.isReference) {
                this.mutuallyExclusiveAttributes("type", "ref");
                return;
            }
            try {
                typeFingerprint = this.getFingerprint(attValue, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            this.checkPermittedType(typeFingerprint, attValue, "an attribute type");
            if (this.attributeDecl != null) {
                this.attributeDecl.setTypeReference(new TypeReference(typeFingerprint, this.getSchema().getConfiguration(), this));
            }
        }
        if ((attValue = atts.getValue("", "use")) != null) {
            short useFlag;
            boolean hasFixed;
            boolean hasDefault;
            boolean bl = hasDefault = atts.getValue("", "default") != null;
            if (hasDefault && !attValue.equals("optional")) {
                this.error("When @default is present, the @use attribute must have the value \"optional\"");
                attValue = "optional";
            }
            boolean bl2 = hasFixed = atts.getValue("", "fixed") != null;
            if (hasFixed && attValue.equals("prohibited") && this.getXSDSchema().getSchemaCompiler().getLanguageVersion() != 10) {
                this.error("When @fixed is present, the @use attribute must not have the value \"prohibited\"");
                attValue = "optional";
            }
            switch (attValue) {
                case "required": {
                    useFlag = 5;
                    break;
                }
                case "optional": {
                    useFlag = 3;
                    break;
                }
                case "prohibited": {
                    useFlag = 4;
                    break;
                }
                default: {
                    this.invalidAttributeValue("use", attValue, "Must be required|optional|prohibited");
                    useFlag = 3;
                }
            }
            if (this.attributeUse != null) {
                this.attributeUse.setUse(useFlag);
            }
        }
        if ((inheritAtt = atts.getValue("", "inheritable")) != null) {
            if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
                this.error("The inheritable attribute cannot be used unless XSD 1.1 is enabled");
            }
            boolean inherit = this.parseBooleanAttribute("inheritable", inheritAtt);
            if (this.attributeUse != null) {
                this.attributeUse.setInheritable(inherit ? 1 : 0);
            }
            if (this.attributeDecl != null) {
                this.attributeDecl.setInheritable(inherit);
            }
        }
        if (atts.getValue("", "fixed") != null || atts.getValue("", "default") != null) {
            SchemaType type;
            boolean needResolver = true;
            if (this.typeSpecified && typeFingerprint < 1024 && (type = BuiltInType.getSchemaType(typeFingerprint)) instanceof SimpleType && !((SimpleType)type).isNamespaceSensitive()) {
                needResolver = false;
            }
            if (needResolver) {
                NamespaceResolver resolver = this.makeNamespaceContext();
                if (this.attributeDecl != null) {
                    this.attributeDecl.setNamespaceResolver(resolver);
                }
                if (this.attributeUse != null) {
                    this.attributeUse.setNamespaceResolver(resolver);
                }
            }
        }
    }

    public AttributeDecl getAttributeDeclaration() {
        return this.attributeDecl;
    }

    public AttributeUse getAttributeUse() {
        return this.attributeUse;
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        String localTargetNamespace = this.getAttributeValue("", "targetNamespace");
        if (localTargetNamespace != null && !localTargetNamespace.equals(this.getXSDSchema().getTargetNamespace())) {
            this.checkLocalTargetNamespace("attribute");
        }
        if (this.attributeDecl != null) {
            NodeInfo anc;
            AxisIterator ancIter = this.iterateAxis((byte)0);
            while ((anc = ancIter.next()) != null) {
                if (!(anc instanceof XSDComplexType)) continue;
                this.attributeDecl.setContainingComplexType(((XSDComplexType)anc).getComplexType());
                break;
            }
        }
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            int fp = child.getFingerprint();
            if (fp == 578) {
                if (this.foundAnnotation) {
                    this.duplicateElement("annotation");
                }
                if (this.foundSimpleType) {
                    this.mustBeFirstElement("annotation");
                }
                this.foundAnnotation = true;
                continue;
            }
            if (fp == 621) {
                if (this.typeSpecified) {
                    this.mutuallyExclusiveElementAndAttribute("simpleType", "type");
                }
                if (this.isReference) {
                    this.mutuallyExclusiveElementAndAttribute("simpleType", "ref");
                }
                if (this.foundSimpleType) {
                    this.duplicateElement("simpleType");
                }
                this.foundSimpleType = true;
                continue;
            }
            this.illegalElement(child);
        }
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            int fp = child.getFingerprint();
            if (fp != 621 || this.attributeDecl == null) continue;
            SimpleTypeDefinition simpleTypeDef = ((XSDSimpleType)child).getSimpleTypeDefinition();
            TypeReference ref = new TypeReference(simpleTypeDef.getFingerprint(), this.getSchema().getConfiguration(), this);
            this.attributeDecl.setTypeReference(ref);
            simpleTypeDef.setContainingDeclaration(this.attributeDecl.getComponentName(), false);
            simpleTypeDef.setContextComponent(this.attributeDecl);
        }
    }
}

