/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.util.ArrayList;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.util.Span;

public class NewlineSentenceDetector
implements SentenceDetector {
    @Override
    public String[] sentDetect(CharSequence s2) {
        return Span.spansToStrings(this.sentPosDetect(s2), s2);
    }

    @Override
    public Span[] sentPosDetect(CharSequence s2) {
        Span span;
        ArrayList<Span> sentences = new ArrayList<Span>();
        int start = 0;
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c != '\n' && c != '\r' || i - start <= 0) continue;
            Span span2 = new Span(start, i).trim(s2);
            if (span2.length() > 0) {
                sentences.add(span2);
            }
            start = i + 1;
        }
        if (s2.length() - start > 0 && (span = new Span(start, s2.length()).trim(s2)).length() > 0) {
            sentences.add(span);
        }
        return sentences.toArray(new Span[0]);
    }
}

