/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.IOException;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorTrainerTool;
import opennlp.tools.cmdline.sentdetect.SentenceEvaluationErrorListener;
import opennlp.tools.cmdline.sentdetect.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.SDCrossValidator;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.sentdetect.SentenceSampleStream;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SentenceDetectorCrossValidatorTool
extends AbstractCrossValidatorTool<SentenceSample, CVToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(SentenceDetectorCrossValidatorTool.class);

    public SentenceDetectorCrossValidatorTool() {
        super(SentenceSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable sentence detector";
    }

    @Override
    public void run(String format, String[] args2) {
        SDCrossValidator validator;
        super.run(format, args2);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        SentenceEvaluationErrorListener errorListener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            errorListener = new SentenceEvaluationErrorListener();
        }
        char[] eos = null;
        if (((CVToolParams)this.params).getEosChars() != null) {
            String eosString = SentenceSampleStream.replaceNewLineEscapeTags(((CVToolParams)this.params).getEosChars());
            eos = eosString.toCharArray();
        }
        try {
            Dictionary abbreviations = SentenceDetectorTrainerTool.loadDict(((CVToolParams)this.params).getAbbDict());
            SentenceDetectorFactory sdFactory = SentenceDetectorFactory.create(((CVToolParams)this.params).getFactory(), ((CVToolParams)this.params).getLang(), true, abbreviations, eos);
            validator = new SDCrossValidator(((CVToolParams)this.params).getLang(), this.mlParams, sdFactory, errorListener);
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        FMeasure result2 = validator.getFMeasure();
        logger.info(result2.toString());
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams {
    }
}

