/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AbsorptionFeed;
import com.saxonica.ee.stream.feed.CopyOfFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.List;
import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SnapshotFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;

public class SnapshotFeed
extends AbsorptionFeed {
    private WatchManager watchManager;

    public static Trigger getWatch(Feed result, Pattern selection, WatchManager wm, XPathContext context) {
        SnapshotFeed action = new SnapshotFeed(wm, result, context);
        Trigger watch = new Trigger(selection, action, context);
        watch.setPipelineConfiguration(wm.getPipelineConfiguration());
        return watch;
    }

    public SnapshotFeed(WatchManager watchManager, Feed result, XPathContext context) {
        super(result, context);
        this.watchManager = watchManager;
    }

    @Override
    protected AbsorptionFeed.PendingItem makePendingItem(int sequenceNr, FleetingParentNode node) throws XPathException {
        return new PendingSnapshotAction(sequenceNr, node);
    }

    @Override
    protected Sequence<?> processGroundedItem(Item item) {
        return SnapshotFn.snapshotSingle(item);
    }

    private class PendingSnapshotAction
    extends AbsorptionFeed.PendingItem {
        public int sequence;
        public BuilderMonitor monitor;
        public List<NodeInfo> ancestorList;

        public PendingSnapshotAction(int sequence, FleetingParentNode node) throws XPathException {
            super(sequence);
            this.sequence = sequence;
            this.ancestorList = SnapshotFn.makeAncestorList(node);
            this.monitor = SnapshotFn.openAncestors(node, this.ancestorList, SnapshotFeed.this.getContext());
            this.monitor.markNextNode(node.getNodeKind());
        }

        @Override
        public Receiver getGatherer() throws XPathException {
            TinyBuilder builder = (TinyBuilder)this.monitor.getNextReceiver();
            return new CopyOfFeed.AccumulatorCopier(SnapshotFeed.this.watchManager, this.monitor, builder);
        }

        @Override
        public Sequence<?> deliver() throws XPathException {
            SnapshotFn.closeAncestors(this.ancestorList, this.monitor);
            return this.monitor.getMarkedNode();
        }

        @Override
        public void rollback() {
        }
    }
}

