/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.dom4j;

import java.util.HashMap;
import java.util.Stack;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.option.dom4j.DOM4JDocumentWrapper;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultComment;
import org.dom4j.tree.DefaultDocument;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultProcessingInstruction;
import org.dom4j.tree.DefaultText;

public class DOM4JWriter
extends Builder {
    private Document document;
    private Stack<Branch> ancestors = new Stack();
    private boolean implicitDocumentNode = false;
    private FastStringBuffer textBuffer = new FastStringBuffer(256);
    private HashMap<String, Element> idIndex = new HashMap();

    public DOM4JWriter(PipelineConfiguration pipe) {
        super(pipe);
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.document = new DefaultDocument();
        this.ancestors.push((Branch)this.document);
        this.textBuffer.setLength(0);
    }

    @Override
    public void endDocument() throws XPathException {
        this.ancestors.pop();
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        DefaultElement element;
        this.flush();
        String local = nameCode.getLocalPart();
        String uri = nameCode.getURI();
        String prefix = nameCode.getPrefix();
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        QName name = new QName(local, new Namespace(prefix, uri));
        if (this.ancestors.size() == 1) {
            element = new DefaultElement(name);
            this.document.add((Element)element);
        } else {
            element = this.ancestors.peek().addElement(name);
        }
        this.ancestors.push((Branch)element);
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        for (NamespaceBinding ns : namespaceBindings) {
            String prefix = ns.getPrefix();
            String uri = ns.getURI();
            ((Element)this.ancestors.peek()).addNamespace(prefix, uri);
        }
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        String local = nameCode.getLocalPart();
        String uri = nameCode.getURI();
        String prefix = nameCode.getPrefix();
        Namespace ns = new Namespace(prefix, uri);
        if (uri.equals("http://www.w3.org/XML/1998/namespace") && local.equals("id")) {
            value = Whitespace.trim(value);
            this.idIndex.put(value.toString(), (Element)this.ancestors.peek());
        }
        DefaultAttribute att = new DefaultAttribute(local, value.toString(), ns);
        ((Element)this.ancestors.peek()).add((Attribute)att);
    }

    @Override
    public void startContent() throws XPathException {
        this.flush();
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.ancestors.pop();
        Branch parent = this.ancestors.peek();
        if (parent == this.document && this.implicitDocumentNode) {
            this.endDocument();
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            DefaultText text = new DefaultText(this.textBuffer.toString());
            this.ancestors.peek().add((Node)text);
            this.textBuffer.setLength(0);
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        this.flush();
        DefaultProcessingInstruction pi = new DefaultProcessingInstruction(target, data.toString());
        this.ancestors.peek().add((ProcessingInstruction)pi);
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.flush();
        DefaultComment comment = new DefaultComment(chars.toString());
        this.ancestors.peek().add((Comment)comment);
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        DOM4JDocumentWrapper wrapper = new DOM4JDocumentWrapper(this.document, this.systemId, this.config);
        wrapper.setUserData("saxon-id-index", this.idIndex);
        return wrapper.getRootNode();
    }
}

