/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionsToOffset {
    private String field;
    private LeafReaderContext atomic;
    private boolean processed = false;
    private Integer[] pair;
    private ByteBuffer bbOffset;
    HashSet<PositionsToOffsetArray> positions;
    HashMap<PositionsToOffsetArray, Integer[]> offsets;
    private static final Logger log = LoggerFactory.getLogger(PositionsToOffset.class);
    public static final boolean DEBUG = false;

    public PositionsToOffset(LeafReaderContext atomic, String field) {
        this.field = field;
        this.atomic = atomic;
        this.positions = new HashSet(64);
        this.offsets = new HashMap(64);
        this.bbOffset = ByteBuffer.allocate(8);
    }

    public void clear() {
        this.positions.clear();
        this.offsets.clear();
        this.bbOffset.clear();
        this.processed = false;
    }

    public void add(int docID, int pos) {
        this.add(new PositionsToOffsetArray(docID, pos));
    }

    public void add(PositionsToOffsetArray ptoa) {
        if (ptoa.pos < 0) {
            return;
        }
        if (this.processed && this.exists(ptoa)) {
            return;
        }
        this.positions.add(ptoa);
        this.processed = false;
    }

    public boolean exists(int docID, int pos) {
        return this.offsets.containsKey(new PositionsToOffsetArray(docID, pos));
    }

    public boolean exists(PositionsToOffsetArray ptoa) {
        return this.offsets.containsKey(ptoa);
    }

    public int start(int docID, int pos) {
        return this.start(new PositionsToOffsetArray(docID, pos));
    }

    public int start(PositionsToOffsetArray ptoa) {
        Integer[] pair;
        if (ptoa.pos < 0) {
            return 0;
        }
        if (!this.processed) {
            this.offsets();
        }
        if ((pair = this.offsets.get(ptoa)) == null) {
            return 0;
        }
        return pair[0];
    }

    public int end(int docID, int pos) {
        return this.end(new PositionsToOffsetArray(docID, pos));
    }

    public int end(PositionsToOffsetArray ptoa) {
        Integer[] pair;
        if (ptoa.pos < 0) {
            return -1;
        }
        if (!this.processed) {
            this.offsets();
        }
        if ((pair = this.offsets.get(ptoa)) == null) {
            return -1;
        }
        return pair[1];
    }

    public Integer[] span(int docID, int pos) {
        return this.span(new PositionsToOffsetArray(docID, pos));
    }

    public Integer[] span(PositionsToOffsetArray ptoa) {
        if (!this.processed) {
            this.offsets();
        }
        return this.offsets.get(ptoa);
    }

    public void addOffset(int docID, int pos, int startOffset, int endOffset) {
        this.offsets.put(new PositionsToOffsetArray(docID, pos), new Integer[]{startOffset, endOffset});
    }

    public HashMap<PositionsToOffsetArray, Integer[]> offsets() {
        if (this.processed) {
            return this.offsets;
        }
        StringBuilder sb = new StringBuilder().append('_');
        try {
            Terms terms = this.atomic.reader().fields().terms(this.field);
            if (terms != null) {
                TermsEnum termsEnum = terms.iterator(null);
                for (PositionsToOffsetArray posDoc : this.positions) {
                    DocsAndPositionsEnum docs;
                    if (this.exists(posDoc)) continue;
                    int docID = posDoc.docID;
                    sb.append(posDoc.pos);
                    Term term = new Term(this.field, sb.toString());
                    sb.setLength(1);
                    if (!termsEnum.seekExact(term.bytes()) || (docs = termsEnum.docsAndPositions(null, null, 2)).advance(docID) != docID) continue;
                    docs.nextPosition();
                    BytesRef payload = docs.getPayload();
                    if (payload.length == 8) {
                        this.bbOffset.clear();
                        this.bbOffset.put(payload.bytes, payload.offset, 8);
                        this.bbOffset.rewind();
                        Integer[] offsetArray = new Integer[]{this.bbOffset.getInt(), this.bbOffset.getInt()};
                        this.offsets.put(posDoc, offsetArray);
                        continue;
                    }
                    log.error("Doc {} has no offsets stored for {}", (Object)docID, (Object)term.toString());
                }
            }
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
        }
        this.processed = true;
        this.positions.clear();
        return this.offsets;
    }

    public LeafReaderContext getLeafReader() {
        return this.atomic;
    }

    private class PositionsToOffsetArray {
        public int docID;
        public int pos;

        public PositionsToOffsetArray(int docID, int pos) {
            this.docID = docID;
            this.pos = pos;
        }

        public int hashCode() {
            long hashCode = this.docID * Integer.MAX_VALUE - Integer.MAX_VALUE + this.pos;
            return Long.valueOf(hashCode).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PositionsToOffsetArray) {
                PositionsToOffsetArray ptoa = (PositionsToOffsetArray)obj;
                return ptoa.docID == this.docID && ptoa.pos == this.pos;
            }
            return false;
        }
    }
}

