/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class NumberFnCompiler
extends ToItemCompiler {
    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        if (requiredClass != Double.TYPE) {
            throw new IllegalArgumentException();
        }
        NumberFnCompiler.visitAnnotation(compiler, "NumberFn-Dbl");
        boolean compiled = this.compileFromPrimitive(compiler, ((SystemFunctionCall)expression).getArg(0));
        if (!compiled) {
            super.compileToPrimitive(compiler, expression, requiredClass, onEmpty);
        }
    }

    private boolean compileFromPrimitive(CompilerService compiler, Expression arg) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        int type = arg.getItemType().getPrimitiveType();
        boolean allowEmpty = Cardinality.allowsZero(arg.getCardinality());
        NumberFnCompiler.visitAnnotation(compiler, "NumberFn");
        LabelInfo exit = methodInfo.newLabel("exit");
        LabelInfo returnNaN = methodInfo.newLabel("returnNaN");
        OnEmpty.UnwindAndJump onEmptyReturnNaN = new OnEmpty.UnwindAndJump(returnNaN);
        boolean compiled = true;
        if (type == 514 && !allowEmpty) {
            compiler.compileToBoolean(arg);
            ga.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
        } else if (type == 517) {
            compiler.compileToPrimitive(arg, Double.TYPE, onEmptyReturnNaN);
        } else if (type == 516) {
            compiler.compileToPrimitive(arg, Float.TYPE, onEmptyReturnNaN);
            ga.cast(Type.FLOAT_TYPE, Type.DOUBLE_TYPE);
        } else if (type == 533 && compiler.isInRangeForLong(arg)) {
            compiler.compileToPrimitive(arg, Long.TYPE, onEmptyReturnNaN);
            ga.cast(Type.LONG_TYPE, Type.DOUBLE_TYPE);
        } else if (type == 513 || type == 631) {
            compiler.compileToPrimitive(arg, CharSequence.class, onEmptyReturnNaN);
            StringToDouble s2d = compiler.getConfiguration().getConversionRules().getStringToDoubleConverter();
            NumberFnCompiler.allocateStatic(compiler, s2d);
            ga.swap();
            ga.invokeStaticMethod(Callback.class, "stringToNumberOrNaN", StringToDouble.class, CharSequence.class);
        } else {
            compiled = false;
        }
        if (compiled) {
            ga.goTo(exit);
            methodInfo.placeLabel(returnNaN);
            ga.push(Double.NaN);
            methodInfo.placeLabel(exit);
        }
        return compiled;
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        ItemType type;
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        NumberFnCompiler.visitAnnotation(compiler, "NumberFn-Item");
        Expression arg = ((SystemFunctionCall)expression).getArg(0);
        boolean compiled = this.compileFromPrimitive(compiler, arg);
        if (compiled) {
            ga.invokeStaticMethod(DoubleValue.class, "makeDoubleValue", Double.TYPE);
            return;
        }
        LabelInfo numberFnReturn = methodInfo.newLabel("numberFnReturn");
        compiler.compileToItem(arg);
        int valueVar = methodInfo.allocateLocal(Item.class);
        ga.storeLocal(valueVar);
        if (Cardinality.allowsZero(arg.getCardinality())) {
            LabelInfo nonNull = methodInfo.newLabel("nonNull");
            ga.loadLocal(valueVar);
            ga.ifNonNull(nonNull.label());
            ga.getStaticField(DoubleValue.class, "NaN", DoubleValue.class);
            ga.goTo(numberFnReturn);
            methodInfo.placeLabel(nonNull);
        }
        if (th.relationship(type = arg.getItemType(), BuiltInAtomicType.BOOLEAN) != 4) {
            LabelInfo nonBoolean = methodInfo.newLabel("nonBoolean");
            ga.loadLocal(valueVar);
            ga.ifNotInstance(BooleanValue.class, nonBoolean);
            ga.newInstance(DoubleValue.class);
            ga.dup();
            ga.loadLocal(valueVar);
            ga.checkClass(BooleanValue.class);
            ga.invokeInstanceMethod(BooleanValue.class, "getBooleanValue", new Class[0]);
            ga.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
            ga.invokeConstructor(DoubleValue.class, Double.TYPE);
            ga.goTo(numberFnReturn);
            methodInfo.placeLabel(nonBoolean);
        }
        if (th.relationship(type, BuiltInAtomicType.DOUBLE) != 4) {
            LabelInfo nonDouble = methodInfo.newLabel("nonDouble");
            ga.loadLocal(valueVar);
            ga.ifNotInstance(DoubleValue.class, nonDouble);
            ga.loadLocal(valueVar);
            ga.goTo(numberFnReturn);
            methodInfo.placeLabel(nonDouble);
        }
        if (th.relationship(type, NumericType.getInstance()) != 4) {
            LabelInfo nonNumeric = methodInfo.newLabel("nonNumeric");
            ga.loadLocal(valueVar);
            ga.ifNotInstance(NumericValue.class, nonNumeric);
            ga.newInstance(DoubleValue.class);
            ga.dup();
            ga.loadLocal(valueVar);
            ga.checkClass(NumericValue.class);
            ga.invokeInstanceMethod(NumericValue.class, "getDoubleValue", new Class[0]);
            ga.invokeConstructor(DoubleValue.class, Double.TYPE);
            ga.goTo(numberFnReturn);
            methodInfo.placeLabel(nonNumeric);
        }
        if (th.relationship(type, BuiltInAtomicType.STRING) != 4 || th.relationship(type, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            LabelInfo nonString = methodInfo.newLabel("nonString");
            ga.loadLocal(valueVar);
            ga.ifNotInstance(StringValue.class, nonString);
            ga.loadLocal(valueVar);
            ga.ifInstance(AnyURIValue.class, nonString);
            NumberFnCompiler.allocateStatic(compiler, BuiltInAtomicType.DOUBLE.getStringConverter(compiler.getConfiguration().getConversionRules()));
            ga.loadLocal(valueVar);
            ga.checkClass(AtomicValue.class);
            ga.invokeInstanceMethod(Converter.class, "convert", AtomicValue.class);
            ga.dup();
            LabelInfo notFailure = methodInfo.newLabel("notFailure");
            ga.ifNotInstance(ValidationFailure.class, notFailure);
            ga.pop();
            ga.getStaticField(DoubleValue.class, "NaN", DoubleValue.class);
            ga.goTo(numberFnReturn);
            methodInfo.placeLabel(notFailure);
            ga.checkClass(DoubleValue.class);
            ga.goTo(numberFnReturn);
            methodInfo.placeLabel(nonString);
        }
        ga.getStaticField(DoubleValue.class, "NaN", DoubleValue.class);
        methodInfo.placeLabel(numberFnReturn);
        methodInfo.releaseLocal(valueVar);
    }
}

