/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.SimpleNodeConstructorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class ValueOfCompiler
extends SimpleNodeConstructorCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        ValueOf valueOf = (ValueOf)expression;
        Expression select = valueOf.getSelect();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ValueOfCompiler.visitAnnotation(compiler, "ValueOfCompiler");
        LabelInfo notNull = methodInfo.newLabel("notNullValOf");
        LabelInfo done = methodInfo.newLabel("doneValOf");
        LabelInfo end = methodInfo.newLabel("endValOf");
        int valVar = methodInfo.allocateLocal(CharSequence.class);
        if (th.isSubType(select.getItemType(), BuiltInAtomicType.STRING) && !Cardinality.allowsZero(select.getCardinality())) {
            compiler.compileToPrimitive(select, CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
            ga.storeLocal(valVar);
        } else {
            compiler.compileToItem(select);
            if (Cardinality.allowsZero(select.getCardinality())) {
                ga.dup();
                ga.ifNonNull(notNull.label());
                ga.pop();
                if (valueOf.isNoNodeIfEmpty()) {
                    ga.pushNull();
                    ga.goTo(end);
                } else {
                    ga.push("");
                    ga.storeLocal(valVar);
                    ga.goTo(done);
                }
                methodInfo.placeLabel(notNull);
            }
            ValueOfCompiler.visitLineNumber(compiler, ga, expression);
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            ga.storeLocal(valVar);
            methodInfo.placeLabel(done);
        }
        ga.newInstance(Type.getType(Orphan.class));
        ga.dup();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getConfiguration", new Class[0]);
        ga.invokeConstructor(Orphan.class, Configuration.class);
        int oVar = methodInfo.allocateLocal(Orphan.class);
        ga.storeLocal(oVar);
        ga.loadLocal(oVar);
        ga.push(3);
        ga.invokeInstanceMethod(Orphan.class, "setNodeKind", Short.TYPE);
        ga.loadLocal(oVar);
        ga.loadLocal(valVar);
        ga.invokeInstanceMethod(Orphan.class, "setStringValue", CharSequence.class);
        ga.loadLocal(oVar);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(valVar);
        methodInfo.releaseLocal(oVar);
    }

    @Override
    protected boolean isNoNodeIfEmpty(Expression expr) {
        return ((ValueOf)expr).isNoNodeIfEmpty();
    }

    @Override
    protected void pushNode(CompilerService compiler, Expression expression) {
        ValueOf expr = (ValueOf)expression;
        Generator ga = compiler.getCurrentGenerator();
        ValueOfCompiler.allocateStatic(compiler, expr.getLocation());
        ga.push(expr.getOptions());
        ga.invokeInstanceMethod(Receiver.class, "characters", CharSequence.class, Location.class, Integer.TYPE);
    }
}

