/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.domino;

import com.saxonica.ee.domino.DominoNode;
import com.saxonica.ee.domino.Erector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntToIntHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class DominoTree
extends GenericTreeInfo
implements NodeVectorTree {
    public static final int HAS_PARENT_POINTER = 0x1000000;
    public static final int HAS_ATTRIBUTES = 0x2000000;
    public static final int HAS_NAMESPACES = 0x4000000;
    public static final int HAS_CONTINUATION = 0x8000000;
    protected int numberOfNodes = 0;
    public byte[] nodeKind;
    protected short[] depth;
    protected int[] next;
    protected int[] nameCode;
    protected int[] prior = null;
    protected Node[] domNodes;
    private IntHashMap<NamespaceBinding[]> namespaceDeclarations = new IntHashMap();
    private IntToIntHashMap extraParentPointers = new IntToIntHashMap();
    private IntHashMap<List<NodeInfo>> elementsByFingerprint;
    private HashMap<String, String[]> unparsedEntities;
    private DominoNode root;
    private HashMap<String, Integer> idTable;

    DominoTree(Configuration config) {
        super(config);
        int nodes = 100;
        this.nodeKind = new byte[nodes];
        this.depth = new short[nodes];
        this.next = new int[nodes];
        this.nameCode = new int[nodes];
        this.domNodes = new Node[nodes];
        this.setConfiguration(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DominoTree makeTree(Document doc, Configuration config, String systemId) throws XPathException {
        if (!config.isLicensedFeature(4) && !config.isLicensedFeature(2)) {
            throw new XPathException("Use of Domino Tree model requires a Saxon-EE license");
        }
        Document document = doc;
        synchronized (document) {
            Erector erector = new Erector(doc, systemId, config);
            return erector.erect();
        }
    }

    @Override
    public void setConfiguration(Configuration config) {
        super.setConfiguration(config);
        this.addNamespace(0, NamespaceBinding.XML);
    }

    private void ensureNodeCapacity(short kind) {
        if (this.nodeKind.length < this.numberOfNodes + 1) {
            int k = kind == 11 ? this.numberOfNodes + 1 : this.numberOfNodes * 2;
            this.nodeKind = Arrays.copyOf(this.nodeKind, k);
            this.next = Arrays.copyOf(this.next, k);
            this.depth = Arrays.copyOf(this.depth, k);
            this.nameCode = Arrays.copyOf(this.nameCode, k);
            this.domNodes = Arrays.copyOf(this.domNodes, k);
        }
    }

    int addNode(short kind, int depth, int nameCode, Node domNode) {
        this.ensureNodeCapacity(kind);
        this.nodeKind[this.numberOfNodes] = (byte)kind;
        this.depth[this.numberOfNodes] = (short)depth;
        this.domNodes[this.numberOfNodes] = domNode;
        this.nameCode[this.numberOfNodes] = nameCode;
        this.next[this.numberOfNodes] = -1;
        if (this.numberOfNodes == 0) {
            this.setDocumentNumber(this.getConfiguration().getDocumentNumberAllocator().allocateDocumentNumber());
        }
        return this.numberOfNodes++;
    }

    public void setCurrentNode(Node node) {
        this.domNodes[this.numberOfNodes - 1] = node;
    }

    public Node getDomNode(int nodeNr) {
        return this.domNodes[nodeNr];
    }

    public void addParentPointer(int node, int parent) {
        this.extraParentPointers.put(node, parent);
    }

    void condense() {
        if (this.numberOfNodes * 3 < this.nodeKind.length || this.nodeKind.length - this.numberOfNodes > 20000) {
            this.nodeKind = Arrays.copyOf(this.nodeKind, this.numberOfNodes);
            this.next = Arrays.copyOf(this.next, this.numberOfNodes);
            this.depth = Arrays.copyOf(this.depth, this.numberOfNodes);
            this.nameCode = Arrays.copyOf(this.nameCode, this.numberOfNodes);
            this.domNodes = Arrays.copyOf(this.domNodes, this.numberOfNodes);
        }
    }

    public void addUnparsedEntity(String name, String systemId, String publicId) {
        if (this.unparsedEntities == null) {
            this.unparsedEntities = new HashMap(4);
        }
        this.unparsedEntities.put(name, new String[]{systemId, publicId});
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        if (this.unparsedEntities == null) {
            List e = Collections.emptyList();
            return e.iterator();
        }
        return this.unparsedEntities.keySet().iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        if (this.unparsedEntities == null) {
            return null;
        }
        return this.unparsedEntities.get(name);
    }

    public SchemaType getSchemaType(int nodeNr) {
        return Untyped.getInstance();
    }

    @Override
    public int getNodeKind(int nodeNr) {
        return this.nodeKind[nodeNr];
    }

    @Override
    public int getFingerprint(int nodeNr) {
        int fp = this.nameCode[nodeNr] & 0xFFFFF;
        return fp == 1048575 ? -1 : fp;
    }

    void ensurePriorIndex() {
        if (this.prior == null) {
            this.makePriorIndex();
        }
    }

    private synchronized void makePriorIndex() {
        int[] p = new int[this.numberOfNodes];
        Arrays.fill(p, 0, this.numberOfNodes, -1);
        for (int i = 0; i < this.numberOfNodes; ++i) {
            int nextNode = this.next[i];
            if (nextNode <= i) continue;
            p[nextNode] = i;
        }
        this.prior = p;
    }

    int getParentNodeNr(int nodeNr) {
        if (this.depth[nodeNr] == 0) {
            return -1;
        }
        int p = this.next[nodeNr];
        while (p >= nodeNr) {
            if ((this.nameCode[p] & 0x1000000) != 0) {
                return this.extraParentPointers.get(p);
            }
            p = this.next[p];
        }
        return p;
    }

    void addNamespace(int parent, NamespaceBinding binding) {
        NamespaceBinding[] bindings = this.namespaceDeclarations.get(parent);
        if (bindings == null) {
            bindings = new NamespaceBinding[]{binding};
            this.namespaceDeclarations.put(parent, bindings);
        } else {
            NamespaceBinding[] b2 = Arrays.copyOf(bindings, bindings.length + 1);
            b2[bindings.length] = binding;
            this.namespaceDeclarations.put(parent, b2);
        }
    }

    NamespaceBinding[] getNamespaceBindings(int nodeNr) {
        return this.namespaceDeclarations.get(nodeNr);
    }

    @Override
    public final DominoNode getNode(int nr) {
        return new DominoNode(this, nr);
    }

    @Override
    public DominoNode getRootNode() {
        if (this.getNodeKind(0) == 9) {
            if (this.root != null) {
                return this.root;
            }
            this.root = new DominoNode(this, 0);
            return this.root;
        }
        return this.getNode(0);
    }

    void registerID(int nodeNr, String id) {
        if (this.idTable == null) {
            this.idTable = new HashMap(256);
        }
        this.idTable.putIfAbsent(id, nodeNr);
    }

    @Override
    public DominoNode selectID(String id, boolean getParent) {
        if (this.idTable == null) {
            return null;
        }
        Integer nodeNr = this.idTable.get(id);
        if (nodeNr != null) {
            DominoNode node = this.getNode(nodeNr);
            if (getParent) {
                node = node.getParent();
            }
            return node;
        }
        return null;
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    @Override
    public boolean isTyped() {
        return false;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public synchronized AxisIterator getAllElements(int fingerprint) {
        List<NodeInfo> list;
        if (this.elementsByFingerprint == null) {
            this.elementsByFingerprint = new IntHashMap(20);
        }
        if ((list = this.elementsByFingerprint.get(fingerprint)) == null) {
            list = this.makeElementList(fingerprint);
            this.elementsByFingerprint.put(fingerprint, list);
        }
        return new ListIterator.OfNodes(list);
    }

    private List<NodeInfo> makeElementList(int fingerprint) {
        int size = this.getNumberOfNodes() / 20;
        if (size > 100) {
            size = 100;
        }
        if (size < 20) {
            size = 20;
        }
        ArrayList<NodeInfo> list = new ArrayList<NodeInfo>(size);
        int i = 1;
        try {
            while (this.depth[i] != 0) {
                if (this.nodeKind[i] == 1 && this.getFingerprint(i) == fingerprint) {
                    list.add(this.getNode(i));
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return list;
        }
        list.trimToSize();
        return list;
    }

    @Override
    public byte[] getNodeKindArray() {
        return this.nodeKind;
    }

    @Override
    public int[] getNameCodeArray() {
        return this.nameCode;
    }
}

