/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanReferenceQuery;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import de.ids_mannheim.korap.util.KrillByte;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;

public class ReferenceSpans
extends SimpleSpans {
    private byte classNum;

    public ReferenceSpans(SpanReferenceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.classNum = query.getClassNum();
        this.hasMoreSpans = this.firstSpans.next();
    }

    @Override
    public boolean next() throws IOException {
        while (this.hasMoreSpans) {
            if (this.hasSameClassPosition()) {
                this.matchStartPosition = this.firstSpans.start();
                this.matchEndPosition = this.firstSpans.end();
                this.matchDocNumber = this.firstSpans.doc();
                this.hasMoreSpans = this.firstSpans.next();
                return true;
            }
            this.hasMoreSpans = this.firstSpans.next();
        }
        return false;
    }

    private boolean hasSameClassPosition() throws IOException {
        int start = 0;
        int end = 0;
        boolean isFound = false;
        boolean match = false;
        this.matchPayload.clear();
        for (byte[] payload : this.firstSpans.getPayload()) {
            if (payload.length == 10 && payload[9] == this.classNum) {
                if (isFound) {
                    if (start == KrillByte.byte2int(payload, 1) && end == KrillByte.byte2int(payload, 5)) {
                        match = true;
                        continue;
                    }
                    match = false;
                    break;
                }
                start = KrillByte.byte2int(payload, 1);
                end = KrillByte.byte2int(payload, 5);
                isFound = true;
                this.matchPayload.add(payload);
                continue;
            }
            this.matchPayload.add(payload);
        }
        return match;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.hasMoreSpans = false;
            return false;
        }
        return this.next();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost();
    }
}

