/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.ids_mannheim.korap.index.KeywordAnalyzer;
import de.ids_mannheim.korap.response.MetaField;
import de.ids_mannheim.korap.response.MetaFields;
import de.ids_mannheim.korap.util.KrillDate;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFieldsObj
implements Iterable<MetaField> {
    private static final Logger log = LoggerFactory.getLogger(MetaFields.class);
    public static final boolean DEBUG = false;
    private static final Pattern dateValuePattern = Pattern.compile("^([0-9]{8})$");
    ObjectMapper mapper = new ObjectMapper();
    public List<String> fieldsOrder;
    private Map<String, MetaField> fieldsMap = new HashMap<String, MetaField>();

    public MetaField add(IndexableField iField) {
        return this.add(MetaFieldsObj.metaFieldFromIndexableField(iField, new MetaField(iField.name(), "type:string")));
    }

    public MetaField add(MetaField mf) {
        if (mf == null) {
            return null;
        }
        if (this.fieldsMap.containsKey(mf.key)) {
            this.fieldsMap.get((Object)mf.key).values.addAll(mf.values);
            return this.fieldsMap.get(mf.key);
        }
        this.fieldsMap.put(mf.key, mf);
        return mf;
    }

    public static MetaField metaFieldFromIndexableField(IndexableField iField, MetaField mf) {
        IndexableFieldType iFieldType = iField.fieldType();
        if (!iFieldType.stored()) {
            return null;
        }
        Number n = iField.numericValue();
        String s = iField.stringValue();
        if (n != null) {
            Matcher dateMatcher = dateValuePattern.matcher(n.toString());
            if (dateMatcher.matches()) {
                mf.type = "type:date";
                KrillDate date = new KrillDate(n.toString());
                if (date != null) {
                    mf.values.add(date.toDisplay());
                }
            } else {
                mf.type = "type:integer";
                mf.values.add(Integer.valueOf(n.intValue()).toString());
            }
        } else if (s != null) {
            if (iFieldType.indexOptions() == IndexOptions.NONE) {
                String value = s.toString();
                mf.type = value.startsWith("data:") ? "type:attachement" : "type:store";
                mf.values.add(value);
                return mf;
            }
            if (iFieldType.indexOptions() == IndexOptions.DOCS_AND_FREQS) {
                mf.type = "type:keywords";
                try {
                    StringReader reader = new StringReader(s.toString());
                    KeywordAnalyzer kwa = new KeywordAnalyzer();
                    TokenStream ts = kwa.tokenStream("-", reader);
                    ts.reset();
                    while (ts.incrementToken()) {
                        CharTermAttribute term = ts.getAttribute(CharTermAttribute.class);
                        mf.values.add(term.toString());
                    }
                    ts.close();
                    reader.close();
                }
                catch (IOException e) {
                    log.error("Unable to split {}={}", (Object)iField.name(), (Object)s.toString());
                }
            } else if (iFieldType.indexOptions() != IndexOptions.DOCS) {
                mf.type = "type:text";
                mf.values.add(s.toString());
            } else if (mf.key.equals("UID")) {
                mf.type = "type:integer";
                mf.values.add(s.toString());
            } else {
                mf.values.add(s.toString());
            }
        } else {
            log.error("Unknown field type {}", (Object)iField.name());
        }
        mf.values.removeAll(Collections.singleton(null));
        return mf;
    }

    public MetaField get(String key) {
        return this.fieldsMap.get(key);
    }

    public Boolean contains(String key) {
        return this.fieldsMap.containsKey(key);
    }

    private Iterator<String> getIterator() {
        if (this.fieldsOrder == null) {
            return this.fieldsMap.keySet().iterator();
        }
        return this.fieldsOrder.iterator();
    }

    @Override
    public Iterator<MetaField> iterator() {
        return new Iterator<MetaField>(){
            private Iterator<String> it;
            private int currentIndex;
            {
                this.it = MetaFieldsObj.this.getIterator();
                this.currentIndex = 0;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public MetaField next() {
                String key = this.it.next();
                MetaField mf = MetaFieldsObj.this.fieldsMap.get(key);
                if (mf == null) {
                    return new MetaField(key);
                }
                return mf;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

