/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.functions.Abs;
import net.sf.saxon.functions.Ceiling;
import net.sf.saxon.functions.Floor;
import net.sf.saxon.functions.Round;
import net.sf.saxon.functions.RoundHalfToEven;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class RoundingCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        SystemFunction rounding = fnc.getTargetFunction();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo notNull = methodInfo.newLabel("roundNotNull");
        LabelInfo end = methodInfo.newLabel("endRound");
        compiler.compileToItem(fnc.getArg(0));
        ga.checkClass(AtomicValue.class);
        ga.dup();
        ga.ifNonNull(notNull.label());
        ga.pop();
        ga.pushNull();
        ga.goTo(end);
        methodInfo.placeLabel(notNull);
        ga.checkClass(NumericValue.class);
        int valVar = methodInfo.allocateLocal(NumericValue.class);
        ga.storeLocal(valVar);
        if (rounding instanceof Floor) {
            ga.loadLocal(valVar);
            ga.invokeInstanceMethod(NumericValue.class, "floor", new Class[0]);
        } else if (rounding instanceof Ceiling) {
            ga.loadLocal(valVar);
            ga.invokeInstanceMethod(NumericValue.class, "ceiling", new Class[0]);
        } else if (rounding instanceof Round) {
            ga.loadLocal(valVar);
            if (rounding.getArity() == 2) {
                compiler.compileToItem(fnc.getArg(1));
                ga.checkClass(NumericValue.class);
                ga.invokeInstanceMethod(NumericValue.class, "longValue", new Class[0]);
                ga.cast(Type.LONG_TYPE, Type.INT_TYPE);
            } else {
                ga.push(0);
            }
            ga.invokeInstanceMethod(NumericValue.class, "round", Integer.TYPE);
        } else if (rounding instanceof RoundHalfToEven) {
            ga.loadLocal(valVar);
            LabelInfo doRounding = null;
            if (rounding.getArity() == 2) {
                compiler.compileToItem(fnc.getArg(1));
                ga.checkClass(NumericValue.class);
                IntegerValue[] bounds = fnc.getArg(1).getIntegerBounds();
                if (bounds == null || bounds[0].compareTo(Integer.MAX_VALUE) > 0) {
                    LabelInfo notTooBig = methodInfo.newLabel("notTooBig");
                    ga.dup();
                    ga.push((long)Integer.MAX_VALUE);
                    ga.invokeInstanceMethod(NumericValue.class, "compareTo", Long.TYPE);
                    ga.ifZCmp(158, notTooBig.label());
                    ga.pop();
                    ga.goTo(end);
                    methodInfo.placeLabel(notTooBig);
                }
                if (bounds == null || bounds[0].compareTo(Integer.MIN_VALUE) < 0) {
                    LabelInfo notTooSmall = methodInfo.newLabel("notTooBig");
                    doRounding = methodInfo.newLabel("doRounding");
                    ga.dup();
                    ga.push((long)Integer.MIN_VALUE);
                    ga.invokeInstanceMethod(NumericValue.class, "compareTo", Long.TYPE);
                    ga.ifZCmp(156, notTooSmall.label());
                    ga.pop();
                    ga.push(Integer.MIN_VALUE);
                    ga.goTo(doRounding);
                    methodInfo.placeLabel(notTooSmall);
                }
                ga.invokeInstanceMethod(NumericValue.class, "longValue", new Class[0]);
                ga.cast(Type.LONG_TYPE, Type.INT_TYPE);
            } else {
                ga.push(0);
            }
            if (doRounding != null) {
                methodInfo.placeLabel(doRounding);
            }
            ga.invokeInstanceMethod(NumericValue.class, "roundHalfToEven", Integer.TYPE);
        } else if (rounding instanceof Abs) {
            ga.loadLocal(valVar);
            ga.invokeInstanceMethod(NumericValue.class, "abs", new Class[0]);
        } else {
            throw new UnsupportedOperationException("Unknown rounding function");
        }
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(valVar);
    }
}

