/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.sdoc.SaxonParam;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;

public class XSDDocumentation
extends SchemaElement {
    @Override
    public void processAllAttributes() throws SchemaException {
        this.prepareAttributes();
        if (this.getFingerprint() == 581) {
            NodeInfo child;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = kids.next()) != null) {
                if (!(child instanceof SaxonParam)) continue;
                ((SchemaElement)child).processAllAttributes();
            }
        }
    }

    @Override
    public void prepareAttributes() throws SchemaException {
        ValidationFailure vf;
        String lang;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"source"};
        this.allowAttributes(atts, allowed);
        String source = atts.getValue("", "source");
        if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10 && source != null && !StandardURIChecker.getInstance().isValidURI(source)) {
            this.error("Value of source attribute must be a valid anyURI value");
        }
        if ((lang = atts.getValue("http://www.w3.org/XML/1998/namespace", "lang")) != null && (vf = StringConverter.StringToLanguage.INSTANCE.validate(lang)) != null) {
            this.error("Value of xml:lang attribute is not a valid language code");
        }
    }

    @Override
    public void validateSubtree(SchemaCompiler compiler) {
    }

    @Override
    public void validate(SchemaCompiler compiler) {
    }
}

