/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lemming.lemma.ranker.RankerCandidate;
import marmot.core.Evaluator;
import marmot.core.Sequence;
import marmot.core.State;
import marmot.core.Tagger;
import marmot.core.Token;
import marmot.core.lattice.Hypothesis;
import marmot.core.lattice.SequenceViterbiLattice;
import marmot.core.lattice.SumLattice;
import marmot.core.lattice.ViterbiLattice;
import marmot.core.lattice.ZeroOrderSumLattice;
import marmot.core.lattice.ZeroOrderViterbiLattice;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.MorphResult;
import marmot.morph.MorphTagger;
import marmot.morph.Sentence;
import marmot.morph.Word;
import marmot.morph.cmd.Trainer;
import marmot.morph.io.SentenceReader;
import marmot.util.Copy;

public class MorphEvaluator
implements Evaluator {
    private Collection<Sequence> sentences_;

    public MorphEvaluator(Collection<Sequence> sentences) {
        this.sentences_ = sentences;
    }

    public static MorphResult eval(Tagger tagger, Sentence sentence) {
        MorphModel model = (MorphModel)tagger.getModel();
        MorphResult result2 = new MorphResult(tagger);
        for (Token token2 : sentence) {
            Word word = (Word)token2;
            model.addIndexes(word, false);
        }
        ++result2.num_sentences;
        long time = System.currentTimeMillis();
        SumLattice sum_lattice = tagger.getSumLattice(false, sentence);
        result2.sum_lattice_time += System.currentTimeMillis() - time;
        List<List<State>> candidates = sum_lattice.getCandidates();
        ViterbiLattice lattice = sum_lattice instanceof ZeroOrderSumLattice ? new ZeroOrderViterbiLattice(candidates, model.getOptions().getBeamSize(), model.getMarganlizeLemmas()) : new SequenceViterbiLattice(candidates, model.getBoundaryState(tagger.getNumLevels() - 1), model.getOptions().getBeamSize(), model.getMarganlizeLemmas());
        for (List<State> states : candidates) {
            result2.num_states += states.size();
            ++result2.candidates_length;
        }
        Hypothesis h2 = lattice.getViterbiSequence();
        result2.time += System.currentTimeMillis() - time;
        List<Integer> candidate_indexes = h2.getStates();
        ArrayList<int[]> expected_indexes = new ArrayList<int[]>();
        for (Token token3 : sentence) {
            expected_indexes.add(token3.getTagIndexes());
        }
        int rank = MorphEvaluator.getRankOfSequence(tagger, sentence, lattice, candidates);
        if (rank > 0 && rank - 1 < result2.rank.length) {
            int n = rank - 1;
            result2.rank[n] = result2.rank[n] + 1;
        }
        boolean sentence_error = false;
        for (int index = 0; index < sentence.size(); ++index) {
            Word word = (Word)sentence.get(index);
            int form_index = word.getWordFormIndex();
            boolean is_oov = model.isOOV(form_index);
            State state = candidates.get(index).get(candidate_indexes.get(index)).getZeroOrderState();
            assert (state != null);
            boolean token_error = false;
            State run = state;
            for (int level = tagger.getNumLevels() - 1; level >= 0; --level) {
                boolean is_error;
                assert (run != null);
                int expected_tag = ((int[])expected_indexes.get(index))[level];
                int actual_tag = run.getIndex();
                run = run.getSubLevelState();
                boolean bl = is_error = expected_tag != actual_tag;
                if (is_error) {
                    sentence_error = true;
                    int n = level;
                    result2.token_errors[n] = result2.token_errors[n] + 1;
                    token_error = true;
                }
                if (!is_oov || !is_error) continue;
                int n = level;
                result2.oov_errors[n] = result2.oov_errors[n] + 1;
            }
            assert (state != null);
            List<RankerCandidate> lemma_candidates = state.getLemmaCandidates();
            if (lemma_candidates != null) {
                RankerCandidate candidate = RankerCandidate.bestCandidate(lemma_candidates);
                String lemma = word.getLemma().toLowerCase();
                assert (lemma != null);
                String plemma = candidate.getLemma();
                if (!lemma.equals(plemma)) {
                    ++result2.lemma_errors;
                    if (is_oov) {
                        ++result2.lemma_oov_errors;
                    }
                }
            }
            if (token_error) {
                ++result2.morph_errors;
                if (is_oov) {
                    ++result2.morph_oov_errors;
                }
            }
            if (is_oov) {
                ++result2.num_oovs;
            }
            ++result2.num_tokens;
        }
        if (sentence_error) {
            ++result2.sentence_errors;
        }
        if (tagger.getGoldIndexes(sentence, candidates) == null) {
            ++result2.num_unreachable_sentences;
        }
        return result2;
    }

    @Override
    public MorphResult eval(Tagger tagger) {
        MorphResult result2 = new MorphResult(tagger.getModel(), tagger.getNumLevels());
        for (Sequence sentence : this.sentences_) {
            result2.increment(MorphEvaluator.eval(tagger, (Sentence)sentence));
        }
        return result2;
    }

    protected static int getRankOfSequence(Tagger tagger, Sentence sentence, ViterbiLattice lattice, List<List<State>> candidates) {
        List<Integer> gold_indexes = tagger.getGoldIndexes(sentence, candidates);
        if (gold_indexes == null) {
            return -1;
        }
        int rank = 0;
        boolean found_hypothesis = false;
        for (Hypothesis h2 : lattice.getNbestSequences()) {
            List<Integer> indexes = h2.getStates();
            if (gold_indexes.equals(indexes)) {
                found_hypothesis = true;
                break;
            }
            ++rank;
        }
        if (!found_hypothesis) {
            return -1;
        }
        return rank;
    }

    public static MorphResult eval(MorphOptions opts, int num_trials, int seed) {
        opts = Copy.clone(opts);
        long wall_time = System.currentTimeMillis();
        MorphResult result2 = null;
        for (int trial = 0; trial < num_trials; ++trial) {
            opts.setProperty("seed", Integer.toString(seed + trial));
            MorphTagger tagger = Trainer.train(opts);
            LinkedList<Sequence> sentences = new LinkedList<Sequence>();
            for (Sequence sentence : new SentenceReader(opts.getTestFile())) {
                sentences.add(sentence);
            }
            MorphEvaluator e = new MorphEvaluator(sentences);
            MorphResult current_result = e.eval(tagger);
            if (result2 == null) {
                result2 = current_result;
                continue;
            }
            result2.increment(current_result);
        }
        result2.time = (System.currentTimeMillis() - wall_time) / (long)num_trials;
        return result2;
    }
}

