/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.commons.Internal;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.BaseModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class CmdLineUtil {
    private static final Logger logger = LoggerFactory.getLogger(CmdLineUtil.class);
    static final int IO_BUFFER_SIZE = 0x100000;

    private CmdLineUtil() {
    }

    public static void checkInputFile(String name, File inFile) {
        String isFailure = null;
        if (inFile.isDirectory()) {
            isFailure = "The " + name + " file is a directory!";
        } else if (!inFile.exists()) {
            isFailure = "The " + name + " file does not exist!";
        } else if (!inFile.canRead()) {
            isFailure = "No permissions to read the " + name + " file!";
        }
        if (null != isFailure) {
            throw new TerminateToolException(-1, isFailure + " Path: " + inFile.getAbsolutePath());
        }
    }

    public static void checkOutputFile(String name, File outFile) {
        String isFailure = null;
        if (outFile.exists()) {
            if (outFile.isDirectory()) {
                isFailure = "The " + name + " file is a directory!";
            } else if (outFile.isFile()) {
                if (!outFile.canWrite()) {
                    isFailure = "No permissions to write the " + name + " file!";
                }
            } else {
                isFailure = "The " + name + " file is not a normal file!";
            }
        } else {
            File parentDir = outFile.getAbsoluteFile().getParentFile();
            if (parentDir != null && parentDir.exists()) {
                if (!parentDir.canWrite()) {
                    isFailure = "No permissions to create the " + name + " file!";
                }
            } else {
                isFailure = "The parent directory of the " + name + " file does not exist, please create it first!";
            }
        }
        if (null != isFailure) {
            throw new TerminateToolException(-1, isFailure + " Path: " + outFile.getAbsolutePath());
        }
    }

    public static FileInputStream openInFile(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new TerminateToolException(-1, "File '" + file + "' cannot be found", e);
        }
    }

    public static InputStreamFactory createInputStreamFactory(File file) {
        try {
            return new MarkableFileInputStreamFactory(file);
        }
        catch (FileNotFoundException e) {
            throw new TerminateToolException(-1, "File '" + file + "' cannot be found", e);
        }
    }

    public static void writeModel(String modelName, File modelFile, BaseModel model) {
        CmdLineUtil.checkOutputFile(modelName + " model", modelFile);
        logger.info("Writing {} model ... ", (Object)modelName);
        long beginModelWritingTime = System.currentTimeMillis();
        try (BufferedOutputStream modelOut = new BufferedOutputStream(new FileOutputStream(modelFile), 0x100000);){
            model.serialize(modelOut);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "Error during writing model file '" + modelFile + "'", e);
        }
        long modelWritingDuration = System.currentTimeMillis() - beginModelWritingTime;
        logger.info(String.format("done (%.3fs)\n", (double)modelWritingDuration / 1000.0));
        logger.info("Wrote {} model to path: {}", (Object)modelName, (Object)modelFile.getAbsolutePath());
    }

    public static int getParameterIndex(String param, String[] args2) {
        for (int i = 0; i < args2.length; ++i) {
            if (!args2[i].startsWith("-") || !args2[i].equals(param)) continue;
            return i;
        }
        return -1;
    }

    public static String getParameter(String param, String[] args2) {
        int i = CmdLineUtil.getParameterIndex(param, args2);
        if (-1 < i && ++i < args2.length) {
            return args2[i];
        }
        return null;
    }

    public static Integer getIntParameter(String param, String[] args2) {
        String value = CmdLineUtil.getParameter(param, args2);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Double getDoubleParameter(String param, String[] args2) {
        String value = CmdLineUtil.getParameter(param, args2);
        try {
            if (value != null) {
                return Double.parseDouble(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static void checkLanguageCode(String code) {
        ArrayList<String> languageCodes = new ArrayList<String>(Arrays.asList(Locale.getISOLanguages()));
        languageCodes.add("x-unspecified");
        if (!languageCodes.contains(code)) {
            throw new TerminateToolException(1, "Unknown language code " + code + ", must be an ISO 639 code!");
        }
    }

    public static boolean containsParam(String param, String[] args2) {
        for (String arg : args2) {
            if (!arg.equals(param)) continue;
            return true;
        }
        return false;
    }

    public static void handleStdinIoError(IOException e) {
        throw new TerminateToolException(-1, "IO Error while reading from stdin: " + e.getMessage(), e);
    }

    public static TerminateToolException createObjectStreamError(IOException e) {
        return new TerminateToolException(-1, "IO Error while creating an Input Stream: " + e.getMessage(), e);
    }

    public static void handleCreateObjectStreamError(IOException e) {
        throw CmdLineUtil.createObjectStreamError(e);
    }

    public static TrainingParameters loadTrainingParameters(String paramFile, boolean supportSequenceTraining) {
        TrainingParameters params = null;
        if (paramFile != null) {
            CmdLineUtil.checkInputFile("Training Parameter", new File(paramFile));
            try (BufferedInputStream paramsIn = new BufferedInputStream(new FileInputStream(paramFile));){
                params = new TrainingParameters(paramsIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Error during parameters loading: " + e.getMessage(), e);
            }
            if (!TrainerFactory.isValid(params)) {
                throw new TerminateToolException(1, "Training parameters file '" + paramFile + "' is invalid!");
            }
            TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(params);
            if (!supportSequenceTraining && trainerType.equals((Object)TrainerFactory.TrainerType.EVENT_MODEL_SEQUENCE_TRAINER)) {
                throw new TerminateToolException(1, "Sequence training is not supported!");
            }
        }
        return params;
    }
}

