/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class InScopeNamespacesFn
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo element = (NodeInfo)arguments[0].head();
        NamespaceMap nsMap = element.getAllNamespaces();
        if (nsMap == null) {
            return EmptySequence.getInstance();
        }
        HashTrieMap dict = new HashTrieMap();
        dict.initialPut(new StringValue("xml", (AtomicType)BuiltInAtomicType.NCNAME), new StringValue("http://www.w3.org/XML/1998/namespace"));
        for (NamespaceBinding binding : nsMap) {
            StringValue prefix = new StringValue(binding.getPrefix(), (AtomicType)(binding.getPrefix().isEmpty() ? BuiltInAtomicType.STRING : BuiltInAtomicType.NCNAME));
            dict.initialPut(prefix, new StringValue(binding.getNamespaceUri().toUnicodeString()));
        }
        return dict;
    }
}

