/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.util;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class KrillString {
    public static String StringfromFile(String path, Charset encoding) throws IOException {
        path = URLDecoder.decode(path, "UTF-8");
        path = path.replaceFirst("^/(.:/)", "$1");
        Path p = Paths.get(path, new String[0]);
        byte[] encoded = Files.readAllBytes(p);
        return new String(encoded, encoding);
    }

    public static String StringfromFile(String path) throws IOException {
        return KrillString.StringfromFile(path, StandardCharsets.UTF_8);
    }

    public static String escapeHTML(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    public static String escapeBrackets(String text) {
        return text.replaceAll("([\\{\\}\\[\\]\\\\])", "\\\\$1");
    }

    public static String quote(String text) {
        return "\"" + text.replaceAll("([\"\\\\])", "\\\\$1") + "\"";
    }

    public static String codePointSubstring(String text, int start, int end) {
        int a = text.offsetByCodePoints(0, start);
        return text.substring(a, text.offsetByCodePoints(a, end - start));
    }

    public static String codePointSubstring(String text, int start) {
        return text.substring(text.offsetByCodePoints(0, start));
    }
}

