/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ElementCreatorCompiler;
import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageTemplate;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.ComputedElement;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class ComputedElementCompiler
extends ElementCreatorCompiler {
    @Override
    protected void pushNodeName(CompilerService compiler, Expression expression) throws CannotCompileException {
        ComputedElement compElement = (ComputedElement)expression;
        Expression nameExpr = compElement.getNameExp();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo notNull = methodInfo.newLabel("notNullEle");
        LabelInfo notNull2 = methodInfo.newLabel("notNullEle2");
        LabelInfo notNull3 = methodInfo.newLabel("notNullEle3");
        LabelInfo uriNotNull = methodInfo.newLabel("uriNotNull");
        LabelInfo notStrInstance = methodInfo.newLabel("notStrInstance");
        LabelInfo notQNameInstance = methodInfo.newLabel("notQNameInstance");
        LabelInfo end = methodInfo.newLabel("endCompElem");
        LabelInfo end1 = methodInfo.newLabel("end1");
        LabelInfo done = methodInfo.newLabel("doneCompElem");
        LabelInfo test1 = methodInfo.newLabel("test1");
        LabelInfo allocLab = methodInfo.newLabel("allocLab");
        LabelInfo notEqual = methodInfo.newLabel("notEqual");
        LabelInfo notEqual2 = methodInfo.newLabel("notEqual2");
        LabelInfo XMLNSTest = methodInfo.newLabel("XMLNSTest");
        int localNameVar = methodInfo.allocateLocal(String.class);
        int uriVar = methodInfo.allocateLocal(String.class);
        ga.pushNull();
        ga.storeLocal(uriVar);
        int prefixVar = methodInfo.allocateLocal(String.class);
        int rawNameVar = methodInfo.allocateLocal(CharSequence.class);
        compiler.compileToItem(nameExpr);
        ga.checkClass(AtomicValue.class);
        ga.dup();
        ga.ifNonNull(notNull.label());
        ga.pop();
        compiler.generateDynamicError("Invalid element name (empty sequence)", compElement.isXSLT() ? "XTDE0820" : "XPTY0004", compElement.getLocation(), false);
        ga.goTo(end);
        methodInfo.placeLabel(notNull);
        ga.dup();
        ga.ifNotInstance(StringValue.class, notStrInstance);
        ga.invokeInstanceMethod(AtomicValue.class, "getStringValueCS", new Class[0]);
        ga.invokeStaticMethod(Whitespace.class, "trimWhitespace", CharSequence.class);
        ga.storeLocal(rawNameVar);
        ga.loadLocal(rawNameVar);
        LabelInfo tryBegin = methodInfo.newLabel("tryBegin");
        LabelInfo tryEnd = methodInfo.newLabel("tryEnd");
        LabelInfo catchBegin = methodInfo.newLabel("catchBegin");
        ga.visitTryCatchBlock(tryBegin, tryEnd, catchBegin, "net/sf/saxon/om/QNameException");
        methodInfo.placeLabel(tryBegin);
        ga.invokeStaticMethod(NameChecker.class, "getQNameParts", CharSequence.class);
        methodInfo.placeLabel(tryEnd);
        ga.dup();
        ga.push(0);
        ga.arrayLoad(Type.getType(String.class));
        ga.storeLocal(prefixVar);
        ga.push(1);
        ga.arrayLoad(Type.getType(String.class));
        ga.storeLocal(localNameVar);
        ga.goTo(test1);
        methodInfo.placeLabel(catchBegin);
        compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Invalid element name: <{$1}>", rawNameVar), compElement.isXSLT() ? "XTDE0820" : "XQDY0074", compElement.getLocation(), false);
        methodInfo.placeLabel(notStrInstance);
        if (compElement.isAllowNameAsQName()) {
            ga.dup();
            ga.ifNotInstance(QNameValue.class, notQNameInstance);
            ga.checkCast(Type.getType(QNameValue.class));
            ga.dup();
            ga.invokeInstanceMethod(QNameValue.class, "getLocalName", new Class[0]);
            ga.storeLocal(localNameVar);
            ga.dup();
            ga.invokeInstanceMethod(QNameValue.class, "getNamespaceURI", new Class[0]);
            ga.storeLocal(uriVar);
            ga.loadLocal(uriVar);
            ga.ifNonNull(notNull2.label());
            ga.push("");
            ga.storeLocal(uriVar);
            methodInfo.placeLabel(notNull2);
            ga.invokeInstanceMethod(QNameValue.class, "getPrefix", new Class[0]);
            ga.storeLocal(prefixVar);
            ga.loadLocal(prefixVar);
            ga.push("xmlns");
            ga.invokeInstanceMethod(String.class, "equals", Object.class);
            ga.ifFalse(notEqual);
            compiler.generateDynamicError("Computed element name has prefix xmlns", "XQDY0096", compElement.getLocation(), false);
            ga.goTo(end);
            methodInfo.placeLabel(notEqual);
            ga.goTo(test1);
            methodInfo.placeLabel(notQNameInstance);
            compiler.generateDynamicError("Computed element name has incorrect type", compElement.isXSLT() ? "XTDE0820" : "XPTY0004", compElement.getLocation(), true);
            ga.goTo(end);
        } else {
            compiler.generateDynamicError("Computed element name has incorrect type", compElement.isXSLT() ? "XTDE0820" : "XPTY0004", compElement.getLocation(), true);
            ga.goTo(end);
        }
        methodInfo.placeLabel(test1);
        Expression namespace = compElement.getNamespaceExp();
        if (namespace == null) {
            ga.loadLocal(uriVar);
            ga.ifNonNull(uriNotNull.label());
            ExpressionCompiler.allocateStatic(compiler, compElement.getNamespaceResolver());
            ga.loadLocal(prefixVar);
            ga.push(true);
            ga.invokeInstanceMethod(NamespaceResolver.class, "getURIForPrefix", String.class, Boolean.TYPE);
            ga.dup();
            ga.ifNonNull(notNull3.label());
            ga.pop();
            compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Undeclared prefix in element name: {$1}", prefixVar), compElement.isXSLT() ? "XTDE0830" : "XQDY0074", compElement.getLocation(), false);
            ga.goTo(end);
            methodInfo.placeLabel(notNull3);
            ga.storeLocal(uriVar);
            methodInfo.placeLabel(uriNotNull);
        } else {
            ga.loadLocal(uriVar);
            ga.ifNonNull(uriNotNull.label());
            if (namespace instanceof StringLiteral) {
                ga.push(((StringLiteral)namespace).getStringValue());
                ga.storeLocal(uriVar);
            } else {
                compiler.compileToPrimitive(namespace, String.class, OnEmpty.RETURN_NULL);
                ga.storeLocal(uriVar);
                ga.invokeStaticMethod(StandardURIChecker.class, "getInstance", new Class[0]);
                ga.loadLocal(uriVar);
                ga.invokeInstanceMethod(StandardURIChecker.class, "isValidURI", CharSequence.class);
                ga.ifTrue(uriNotNull);
                compiler.generateDynamicError("The value of the namespace attribute must be a valid URI", "XTDE0835", compElement.getLocation(), false);
                ga.goTo(end);
            }
            methodInfo.placeLabel(uriNotNull);
            ga.loadLocal(uriVar);
            ga.invokeInstanceMethod(String.class, "length", new Class[0]);
            ga.push(0);
            ga.ifCmp(Type.getType(Integer.TYPE), 154, notEqual2.label());
            ga.push("");
            ga.storeLocal(prefixVar);
            methodInfo.placeLabel(notEqual2);
            ga.loadLocal(prefixVar);
            ga.push("xmlns");
            ga.invokeInstanceMethod(String.class, "equals", Object.class);
            ga.ifFalse(done);
            ga.push("x-xmlns");
            ga.storeLocal(prefixVar);
        }
        methodInfo.placeLabel(done);
        ga.loadLocal(uriVar);
        ga.push("http://www.w3.org/2000/xmlns/");
        ga.invokeInstanceMethod(String.class, "equals", Object.class);
        ga.ifFalse(XMLNSTest);
        compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Cannot create element in namespace {$1}", uriVar), compElement.isXSLT() ? "XTDE0835" : "XQDY0096", compElement.getLocation(), false);
        ga.goTo(end);
        methodInfo.placeLabel(XMLNSTest);
        ga.loadLocal(uriVar);
        ga.push("http://www.w3.org/XML/1998/namespace");
        ga.invokeInstanceMethod(String.class, "equals", Object.class);
        ga.loadLocal(prefixVar);
        ga.push("xml");
        ga.invokeInstanceMethod(String.class, "equals", Object.class);
        ga.ifCmp(Type.getType(Boolean.TYPE), 153, allocLab.label());
        ga.loadLocal(prefixVar);
        ga.loadLocal(uriVar);
        ga.push(compElement.isXSLT());
        ga.push(compElement.getLocation().getSystemId());
        ga.push(compElement.getLocation().getLineNumber());
        ga.invokeStaticMethod(Callback.class, "makeXmlNamespaceException", String.class, String.class, Boolean.TYPE, String.class, Integer.TYPE);
        ga.throwException();
        methodInfo.placeLabel(allocLab);
        ga.newInstance(FingerprintedQName.class);
        ga.dup();
        ga.loadLocal(prefixVar);
        ga.loadLocal(uriVar);
        ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
        ga.loadLocal(localNameVar);
        ga.invokeConstructor(FingerprintedQName.class, String.class, String.class, String.class);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(localNameVar);
        methodInfo.releaseLocal(uriVar);
        methodInfo.releaseLocal(prefixVar);
    }

    @Override
    protected void outputNamespaceNodes(CompilerService compiler, Expression expression) {
    }

    @Override
    public void identifyExpression(CompilerService compiler, Expression expression, String evalMode) {
        ComputedElementCompiler.visitAnnotation(compiler, "ComputedElement-" + evalMode);
    }
}

