/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UseAttributeSet;

public class UseAttributeSetCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        UseAttributeSet instr = (UseAttributeSet)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        compiler.generateGetContext();
        ga.push(instr.getBindingSlot());
        ga.invokeInstanceMethod(XPathContext.class, "getTargetComponent", Integer.TYPE);
        ga.dup();
        ga.invokeInstanceMethod(Component.class, "isHiddenAbstractComponent", new Class[0]);
        LabelInfo notAbstract = methodInfo.newLabel("notAbstract");
        ga.ifFalse(notAbstract);
        compiler.generateDynamicError("Cannot call an abstract attribute-set (" + instr.getTargetAttributeSetName() + ") with no implementation", "XTDE3052", expression.getLocation(), false);
        ga.throwException();
        methodInfo.placeLabel(notAbstract);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
        ga.dupX1();
        ga.dupX2();
        ga.dup2();
        ga.swap();
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentComponent", Component.class);
        UseAttributeSetCompiler.allocateStatic(compiler, expression);
        ga.checkClass(ContextOriginator.class);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setOrigin", ContextOriginator.class);
        ga.invokeInstanceMethod(Component.class, "getActor", new Class[0]);
        ga.checkClass(AttributeSet.class);
        ga.dup();
        ga.invokeInstanceMethod(AttributeSet.class, "getStackFrameMap", new Class[0]);
        ga.dup();
        LabelInfo haveSlotManager = methodInfo.newLabel("haveSlotManager");
        ga.ifNonNull(haveSlotManager.label());
        ga.pop();
        UseAttributeSetCompiler.allocateStatic(compiler, SlotManager.EMPTY);
        methodInfo.placeLabel(haveSlotManager);
        ga.swap();
        ga.dupX2();
        ga.pop();
        ga.invokeInstanceMethod(XPathContextMajor.class, "openStackFrame", SlotManager.class);
        ga.swap();
        ga.invokeInstanceMethod(AttributeSet.class, "expand", XPathContext.class);
    }
}

