/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntIterator;

public class EXPathBinaryFunctionSet
extends BuiltInFunctionSet {
    private static final EXPathBinaryFunctionSet THE_INSTANCE = new EXPathBinaryFunctionSet();
    public static final double VERSION = 1.0;
    public static final NamespaceUri NAMESPACE;
    public static final String PREFIX = "bin";
    public static final NamespaceUri ERROR_NAMESPACE;
    public static final String ERROR_PREFIX = "bin";
    private static final String defaultEndianness = "BE";
    private static final String ERROR_DIFFERENT_LENGTH_ARGUMENTS = "differing-length-arguments";
    private static final String ERROR_INDEX_BEFORE_START = "index-out-of-range";
    private static final String ERROR_INDEX_AFTER_END = "index-out-of-range";
    private static final String ERROR_NEGATIVE_SIZE = "negative-size";
    private static final String ERROR_EMPTY_SEARCH_ITEM = "empty-search-item";
    private static final String ERROR_OCTET_RANGE = "octet-out-of-range";
    private static final String ERROR_NON_NUMERIC_CHAR = "non-numeric-character";
    private static final String ERROR_UNKNOWN_ENCODING = "unknown-encoding";
    private static final String ERROR_CONVERSION = "conversion-error";
    private static final String ERROR_SIGNIFICANCE_ORDER = "unknown-significance-order";
    private static final long QUIET_DOUBLE_NAN = 9221120237041090560L;
    private static final int QUIET_SINGLE_NAN = 2143289344;

    public static EXPathBinaryFunctionSet getInstance() {
        return THE_INSTANCE;
    }

    private EXPathBinaryFunctionSet() {
        this.init();
    }

    private void init() {
        this.register("and", 2, e -> e.populate(BinaryAnd::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()));
        this.register("bin", 1, e -> e.populate(BinaryBin::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.STRING, 24576, EmptySequence.getInstance()));
        this.register("decode-string", 1, e -> e.populate(BinaryDecodeString::new, BuiltInAtomicType.STRING, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()));
        this.register("decode-string", 2, e -> e.populate(BinaryDecodeString::new, BuiltInAtomicType.STRING, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("decode-string", 3, e -> e.populate(BinaryDecodeString::new, BuiltInAtomicType.STRING, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("decode-string", 4, e -> e.populate(BinaryDecodeString::new, BuiltInAtomicType.STRING, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null).arg(3, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("encode-string", 1, e -> e.populate(BinaryEncodeString::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.STRING, 24576, EmptySequence.getInstance()));
        this.register("encode-string", 2, e -> e.populate(BinaryEncodeString::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.STRING, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("find", 3, e -> e.populate(BinaryFind::new, BuiltInAtomicType.INTEGER, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.BASE64_BINARY, 16384, null));
        this.register("from-octets", 1, e -> e.populate(BinaryFromOctets::new, BuiltInAtomicType.BASE64_BINARY, 16384, 0).arg(0, BuiltInAtomicType.INTEGER, 57344, null));
        this.register("hex", 1, e -> e.populate(BinaryHex::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.STRING, 24576, EmptySequence.getInstance()));
        this.register("insert-before", 3, e -> e.populate(BinaryInsertBefore::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.BASE64_BINARY, 24576, null));
        this.register("join", 1, e -> e.populate(BinaryJoin::new, BuiltInAtomicType.BASE64_BINARY, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 57344, null));
        this.register("length", 1, e -> e.populate(BinaryLength::new, BuiltInAtomicType.INTEGER, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, EmptySequence.getInstance()));
        this.register("not", 1, e -> e.populate(BinaryNot::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()));
        this.register("octal", 1, e -> e.populate(BinaryOctal::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.STRING, 24576, EmptySequence.getInstance()));
        this.register("or", 2, e -> e.populate(BinaryOr::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()));
        this.register("pack-double", 1, e -> e.populate(BinaryPackDouble::new, BuiltInAtomicType.BASE64_BINARY, 16384, 0).arg(0, BuiltInAtomicType.DOUBLE, 16384, null));
        this.register("pack-double", 2, e -> e.populate(BinaryPackDouble::new, BuiltInAtomicType.BASE64_BINARY, 16384, 0).arg(0, BuiltInAtomicType.DOUBLE, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("pack-float", 1, e -> e.populate(BinaryPackFloat::new, BuiltInAtomicType.BASE64_BINARY, 16384, 0).arg(0, BuiltInAtomicType.FLOAT, 16384, null));
        this.register("pack-float", 2, e -> e.populate(BinaryPackFloat::new, BuiltInAtomicType.BASE64_BINARY, 16384, 0).arg(0, BuiltInAtomicType.FLOAT, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("pack-integer", 2, e -> e.populate(BinaryPackInteger::new, BuiltInAtomicType.BASE64_BINARY, 16384, 0).arg(0, BuiltInAtomicType.INTEGER, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("pack-integer", 3, e -> e.populate(BinaryPackInteger::new, BuiltInAtomicType.BASE64_BINARY, 16384, 0).arg(0, BuiltInAtomicType.INTEGER, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
        this.register("pad-left", 2, e -> e.populate(BinaryPadLeft::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("pad-left", 3, e -> e.populate(BinaryPadLeft::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("pad-right", 2, e -> e.populate(BinaryPadRight::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("pad-right", 3, e -> e.populate(BinaryPadRight::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("part", 2, e -> e.populate(BinaryPart::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("part", 3, e -> e.populate(BinaryPart::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("shift", 2, e -> e.populate(BinaryShift::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("to-octets", 1, e -> e.populate(BinaryToOctets::new, BuiltInAtomicType.INTEGER, 57344, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null));
        this.register("unpack-double", 2, e -> e.populate(BinaryUnpackDouble::new, BuiltInAtomicType.DOUBLE, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("unpack-double", 3, e -> e.populate(BinaryUnpackDouble::new, BuiltInAtomicType.DOUBLE, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
        this.register("unpack-float", 2, e -> e.populate(BinaryUnpackFloat::new, BuiltInAtomicType.FLOAT, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("unpack-float", 3, e -> e.populate(BinaryUnpackFloat::new, BuiltInAtomicType.FLOAT, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
        this.register("unpack-integer", 3, e -> e.populate(BinaryUnpackInteger::new, BuiltInAtomicType.INTEGER, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("unpack-integer", 4, e -> e.populate(BinaryUnpackInteger::new, BuiltInAtomicType.INTEGER, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null).arg(3, BuiltInAtomicType.STRING, 16384, null));
        this.register("unpack-unsigned-integer", 3, e -> e.populate(BinaryUnpackUnsignedInteger::new, BuiltInAtomicType.INTEGER, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("unpack-unsigned-integer", 4, e -> e.populate(BinaryUnpackUnsignedInteger::new, BuiltInAtomicType.INTEGER, 16384, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null).arg(3, BuiltInAtomicType.STRING, 16384, null));
        this.register("version", 0, e -> e.populate(BinaryVersion::new, BuiltInAtomicType.DECIMAL, 16384, 0));
        this.register("xor", 2, e -> e.populate(BinaryXor::new, BuiltInAtomicType.BASE64_BINARY, 24576, 0).arg(0, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()).arg(1, BuiltInAtomicType.BASE64_BINARY, 24576, EmptySequence.getInstance()));
    }

    @Override
    public NamespaceUri getNamespace() {
        return NamespaceUri.EXPATH_BINARY;
    }

    @Override
    public String getConventionalPrefix() {
        return "bin";
    }

    public static void error(String message, String code) throws XPathException {
        XPathException e = new XPathException(message);
        e.setErrorCodeQName(new StructuredQName("bin", ERROR_NAMESPACE, code));
        throw e;
    }

    private static Base64BinaryValue one(byte[] result) {
        return new Base64BinaryValue(result);
    }

    private static void checkIndex(Base64BinaryValue value, int offset, int length) throws XPathException {
        if (offset < 0) {
            EXPathBinaryFunctionSet.error("Attempting to retrieve data before the start of a binary data type", "index-out-of-range");
        }
        int len = value.getLengthInOctets();
        if (length < 0) {
            EXPathBinaryFunctionSet.error("Requested length of binary section is negative", ERROR_NEGATIVE_SIZE);
        }
        if (offset >= len) {
            EXPathBinaryFunctionSet.error("Attempting to retrieve data beyond the end of a binary data type; index:" + offset + " data:" + len, "index-out-of-range");
        }
        if (offset + length > len) {
            EXPathBinaryFunctionSet.error("Attempting to retrieve data beyond the end of a binary data type; index:" + (offset + length) + " data:" + len, "index-out-of-range");
        }
    }

    private static void checkIndexInclusive(Base64BinaryValue value, int offset, int length) throws XPathException {
        if (offset < 0) {
            EXPathBinaryFunctionSet.error("Attempting to retrieve data before the start of a binary data type", "index-out-of-range");
        }
        int len = value.getLengthInOctets();
        if (length < 0) {
            EXPathBinaryFunctionSet.error("Requested length of binary section is negative", ERROR_NEGATIVE_SIZE);
        }
        if (offset > len) {
            EXPathBinaryFunctionSet.error("Attempting to retrieve data beyond the end of a binary data type; index:" + offset + " data:" + len, "index-out-of-range");
        }
        if (offset + length > len) {
            EXPathBinaryFunctionSet.error("Attempting to retrieve data beyond the end of a binary data type; index:" + (offset + length) + " data:" + len, "index-out-of-range");
        }
    }

    private static void checkSameLength(Base64BinaryValue value1, Base64BinaryValue value2) throws XPathException {
        if (value1.getLengthInOctets() != value2.getLengthInOctets()) {
            EXPathBinaryFunctionSet.error("The arguments to a bitwise operation are differing lengths", ERROR_DIFFERENT_LENGTH_ARGUMENTS);
        }
    }

    private static boolean endianness(Sequence[] args, int position) throws XPathException {
        String s = args.length <= position ? defaultEndianness : args[position].head().getStringValue();
        if (s.equalsIgnoreCase(defaultEndianness) || s.equalsIgnoreCase("most-significant-first") || s.equalsIgnoreCase("big-endian")) {
            return true;
        }
        if (s.equalsIgnoreCase("LE") || s.equalsIgnoreCase("least-significant-first") || s.equalsIgnoreCase("little-endian")) {
            return false;
        }
        EXPathBinaryFunctionSet.error("Unrecognized octet-order request:" + s, ERROR_SIGNIFICANCE_ORDER);
        return false;
    }

    private static Base64BinaryValue inputNumber(String s, int base, int bitLength) throws XPathException {
        int bits = s.length() * bitLength;
        int charsPerOctet = 8 / bitLength;
        int octetLength = (bits + 7) / 8;
        int padLength = bits % 8;
        byte[] result = new byte[octetLength];
        int offset = 0;
        int end = padLength == 0 ? charsPerOctet : padLength / bitLength;
        int b = 0;
        try {
            while (offset < s.length()) {
                result[b++] = (byte)(Integer.parseInt(s.substring(offset, end), base) & 0xFF);
                offset = end;
                end = offset + charsPerOctet;
            }
        }
        catch (NumberFormatException e) {
            EXPathBinaryFunctionSet.error("Wrong character in base " + base + " binary constructor string:" + s, ERROR_NON_NUMERIC_CHAR);
        }
        return EXPathBinaryFunctionSet.one(result);
    }

    private static int find(byte[] data, byte[] pattern, int offset) {
        int[] failure = EXPathBinaryFunctionSet.computeFailure(pattern);
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = offset; i < data.length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    private static void checkEncoding(String encoding) throws XPathException {
        String se = encoding.toUpperCase();
        if (!(se.equals("UTF-8") || se.equals("UTF-16") || se.equals("US-ASCII") || se.equals("ASCII") || se.equals("ISO-8859-1"))) {
            EXPathBinaryFunctionSet.error("Unsupported encoding in binary encode/decode:" + encoding, ERROR_UNKNOWN_ENCODING);
        }
    }

    private static Base64BinaryValue pack(long in, int length, boolean big) {
        byte[] result = new byte[length];
        if (big) {
            while (length > 0) {
                result[--length] = (byte)(in & 0xFFL);
                in >>= 8;
            }
        } else {
            int i = 0;
            while (length-- > 0) {
                result[i++] = (byte)(in & 0xFFL);
                in >>= 8;
            }
        }
        return EXPathBinaryFunctionSet.one(result);
    }

    private static long unpack(byte[] in, int offset, int length, boolean big) {
        long result = 0L;
        if (big) {
            while (length-- > 0) {
                result = (result << 8) + (long)(in[offset++] & 0xFF);
            }
        } else {
            int off = offset + length;
            while (length-- > 0) {
                result = (result << 8) + (long)(in[--off] & 0xFF);
            }
        }
        return result;
    }

    private static byte[] unpackBytes(byte[] in, int offset, int length, boolean big, boolean unsigned) {
        int i;
        byte[] out = new byte[length + (unsigned ? 1 : 0)];
        int n = i = unsigned ? 1 : 0;
        if (big) {
            while (length-- > 0) {
                out[i++] = in[offset++];
            }
        } else {
            int off = offset + length;
            while (length-- > 0) {
                out[i++] = in[--off];
            }
        }
        return out;
    }

    static {
        ERROR_NAMESPACE = NAMESPACE = NamespaceUri.EXPATH_BINARY;
    }

    public static class BinaryXor
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value1 = (Base64BinaryValue)arguments[0].head();
            Base64BinaryValue value2 = (Base64BinaryValue)arguments[1].head();
            if (value1 == null || value2 == null) {
                return EmptySequence.getInstance();
            }
            EXPathBinaryFunctionSet.checkSameLength(value1, value2);
            int len = value1.getLengthInOctets();
            byte[] in1 = value1.getBinaryValue();
            byte[] in2 = value2.getBinaryValue();
            byte[] result = new byte[value1.getLengthInOctets()];
            for (int i = 0; i < len; ++i) {
                result[i] = (byte)(in1[i] ^ in2[i]);
            }
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryVersion
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            return new BigDecimalValue(1.0);
        }
    }

    public static class BinaryUnpackUnsignedInteger
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            int offset = (int)((NumericValue)arguments[1].head()).longValue();
            int len = (int)((NumericValue)arguments[2].head()).longValue();
            EXPathBinaryFunctionSet.checkIndex(value, offset, len);
            byte[] in = value.getBinaryValue();
            boolean bigEnd = EXPathBinaryFunctionSet.endianness(arguments, 3);
            EXPathBinaryFunctionSet.checkIndex(value, offset, len);
            if (len == 0) {
                return Int64Value.ZERO;
            }
            if (len > 7) {
                BigInteger big = BinaryUnpackUnsignedInteger.bigIntegerFromBytes(in, offset, len, bigEnd);
                return new BigIntegerValue(big);
            }
            long result = EXPathBinaryFunctionSet.unpack(in, offset, len, bigEnd);
            return new Int64Value(result);
        }

        private static BigInteger bigIntegerFromBytes(byte[] in, int offset, int len, boolean bigEnd) {
            return new BigInteger(EXPathBinaryFunctionSet.unpackBytes(in, offset, len, bigEnd, true));
        }
    }

    public static class BinaryUnpackInteger
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            boolean negative;
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            int offset = (int)((NumericValue)arguments[1].head()).longValue();
            int len = (int)((NumericValue)arguments[2].head()).longValue();
            EXPathBinaryFunctionSet.checkIndex(value, offset, len);
            boolean bigEnd = EXPathBinaryFunctionSet.endianness(arguments, 3);
            if (len == 0) {
                return Int64Value.ZERO;
            }
            byte[] in = value.getBinaryValue();
            boolean bl = negative = (in[bigEnd ? offset : offset + 1] & 0x80) != 0;
            if (len > 7) {
                BigInteger big = this.bigIntegerFromBytes(offset, len, in, bigEnd);
                return new BigIntegerValue(big);
            }
            long signExt = negative ? -(1L << 8 * len) : 0L;
            long result = EXPathBinaryFunctionSet.unpack(in, offset, len, bigEnd);
            return new Int64Value(result | signExt);
        }

        private BigInteger bigIntegerFromBytes(int offset, int len, byte[] in, boolean bigEnd) {
            return new BigInteger(EXPathBinaryFunctionSet.unpackBytes(in, offset, len, bigEnd, false));
        }
    }

    public static class BinaryUnpackFloat
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            int offset = (int)((NumericValue)arguments[1].head()).longValue();
            int len = 4;
            EXPathBinaryFunctionSet.checkIndex(value, offset, len);
            float f = this.toFloat(value.getBinaryValue(), offset, len, EXPathBinaryFunctionSet.endianness(arguments, 2));
            return Float.isNaN(f) ? FloatValue.NaN : new FloatValue(f);
        }

        private float toFloat(byte[] bytes, int offset, int len, boolean bigEndian) {
            int bits = (int)EXPathBinaryFunctionSet.unpack(bytes, offset, len, bigEndian);
            return Float.intBitsToFloat(bits);
        }
    }

    public static class BinaryUnpackDouble
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            int offset = (int)((NumericValue)arguments[1].head()).longValue();
            int len = 8;
            EXPathBinaryFunctionSet.checkIndex(value, offset, len);
            double d = BinaryUnpackDouble.toDouble(value.getBinaryValue(), offset, len, EXPathBinaryFunctionSet.endianness(arguments, 2));
            return Double.isNaN(d) ? DoubleValue.NaN : new DoubleValue(d);
        }

        private static double toDouble(byte[] bytes, int offset, int len, boolean bigEndian) {
            long bits = EXPathBinaryFunctionSet.unpack(bytes, offset, len, bigEndian);
            return Double.longBitsToDouble(bits);
        }
    }

    public static class BinaryToOctets
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            ArrayList<Int64Value> result = new ArrayList<Int64Value>();
            for (byte b : value.getBinaryValue()) {
                result.add(new Int64Value(b & 0xFF, BuiltInAtomicType.UNSIGNED_BYTE));
            }
            return SequenceExtent.makeSequenceExtent(result);
        }
    }

    public static class BinaryShift
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            int bits = (int)((NumericValue)arguments[1].head()).longValue();
            if (bits == 0) {
                return value;
            }
            int len = value.getLengthInOctets();
            byte[] in = value.getBinaryValue();
            byte[] result = new byte[len];
            int shift = Math.abs(bits);
            int byteShift = shift / 8;
            int bitShift = shift % 8;
            int i = 0;
            int offset = 0;
            byte part = 0;
            if (bits > 0) {
                int partShift = 8 - bitShift;
                if (bitShift == 0) {
                    while (offset < len) {
                        result[i++] = in[offset++];
                    }
                } else {
                    for (offset = byteShift; offset < len; ++offset) {
                        part = (byte)(offset == len - 1 ? 0 : in[offset + 1] >>> partShift);
                        result[i] = (byte)(in[offset] << bitShift | part);
                        ++i;
                    }
                }
            } else {
                i = byteShift;
                int partShift = 8 - bitShift;
                while (i < len) {
                    result[i] = (byte)((in[offset] & 0xFF) >>> bitShift | part);
                    part = (byte)((in[offset] & 0xFF) << partShift);
                    ++i;
                    ++offset;
                }
            }
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryPart
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            int start = (int)((NumericValue)arguments[1].head()).longValue();
            int len = arguments.length == 2 ? Math.max(0, value.getLengthInOctets() - start) : (int)((NumericValue)arguments[2].head()).longValue();
            EXPathBinaryFunctionSet.checkIndexInclusive(value, start, len);
            if (start == 0 && len == value.getLengthInOctets()) {
                return value;
            }
            byte[] result = new byte[len];
            System.arraycopy(value.getBinaryValue(), start, result, 0, len);
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryPadRight
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            int size = (int)((NumericValue)arguments[1].head()).longValue();
            int oct = 0;
            if (arguments.length > 2) {
                oct = (int)((NumericValue)arguments[2].head()).longValue();
            }
            if (size < 0) {
                EXPathBinaryFunctionSet.error("Pad size is negative", EXPathBinaryFunctionSet.ERROR_NEGATIVE_SIZE);
                return null;
            }
            if (oct < 0 || 255 < oct) {
                EXPathBinaryFunctionSet.error("Integer outside octet range in padding:" + oct, EXPathBinaryFunctionSet.ERROR_OCTET_RANGE);
                return null;
            }
            if (size == 0) {
                return value;
            }
            int len = value.getLengthInOctets();
            byte[] in = value.getBinaryValue();
            byte[] result = new byte[len + size];
            System.arraycopy(in, 0, result, 0, len);
            if (oct != 0) {
                Arrays.fill(result, len, len + size, (byte)oct);
            }
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryPadLeft
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            int size = (int)((NumericValue)arguments[1].head()).longValue();
            int oct = 0;
            if (arguments.length > 2) {
                oct = (int)((NumericValue)arguments[2].head()).longValue();
            }
            if (size < 0) {
                EXPathBinaryFunctionSet.error("Pad size is negative", EXPathBinaryFunctionSet.ERROR_NEGATIVE_SIZE);
                return null;
            }
            if (oct < 0 || 255 < oct) {
                EXPathBinaryFunctionSet.error("Integer outside octet range in padding:" + oct, EXPathBinaryFunctionSet.ERROR_OCTET_RANGE);
                return null;
            }
            if (size == 0) {
                return value;
            }
            int len = value.getLengthInOctets();
            byte[] in = value.getBinaryValue();
            byte[] result = new byte[len + size];
            if (oct != 0) {
                Arrays.fill(result, 0, size, (byte)oct);
            }
            System.arraycopy(in, 0, result, size, len);
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryPackInteger
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            IntegerValue value = (IntegerValue)arguments[0].head();
            int requestedLength = (int)((IntegerValue)arguments[1].head()).longValue();
            if (requestedLength < 0) {
                EXPathBinaryFunctionSet.error("Requested length of integer packing is negative", EXPathBinaryFunctionSet.ERROR_NEGATIVE_SIZE);
            }
            BigInteger big = value.asBigInteger();
            byte[] in = big.toByteArray();
            byte[] result = new byte[requestedLength];
            if (big.signum() == -1) {
                Arrays.fill(result, (byte)-1);
            }
            int suppliedLength = in.length;
            if (EXPathBinaryFunctionSet.endianness(arguments, 2)) {
                int bytesToCopy = Math.min(suppliedLength, requestedLength);
                System.arraycopy(in, suppliedLength - bytesToCopy, result, requestedLength - bytesToCopy, bytesToCopy);
            } else {
                int i = 0;
                while (i < requestedLength && suppliedLength > 0) {
                    result[i++] = in[--suppliedLength];
                }
            }
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryPackFloat
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            FloatValue value = (FloatValue)arguments[0].head();
            int bits = value.isNaN() ? 2143289344 : Float.floatToRawIntBits(value.getFloatValue());
            return EXPathBinaryFunctionSet.pack(bits, 4, EXPathBinaryFunctionSet.endianness(arguments, 1));
        }
    }

    public static class BinaryPackDouble
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            DoubleValue value = (DoubleValue)arguments[0].head();
            long bits = value.isNaN() ? 9221120237041090560L : Double.doubleToRawLongBits(value.getDoubleValue());
            return EXPathBinaryFunctionSet.pack(bits, 8, EXPathBinaryFunctionSet.endianness(arguments, 1));
        }
    }

    public static class BinaryOr
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value1 = (Base64BinaryValue)arguments[0].head();
            Base64BinaryValue value2 = (Base64BinaryValue)arguments[1].head();
            if (value1 == null || value2 == null) {
                return EmptySequence.getInstance();
            }
            EXPathBinaryFunctionSet.checkSameLength(value1, value2);
            int len = value1.getLengthInOctets();
            byte[] in1 = value1.getBinaryValue();
            byte[] in2 = value2.getBinaryValue();
            byte[] result = new byte[value1.getLengthInOctets()];
            for (int i = 0; i < len; ++i) {
                result[i] = (byte)(in1[i] | in2[i]);
            }
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryOctal
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            StringValue s = (StringValue)arguments[0].head();
            if (s == null) {
                return EmptySequence.getInstance();
            }
            StringBuilder binary = new StringBuilder();
            IntIterator iter = s.getUnicodeStringValue().codePoints();
            while (iter.hasNext()) {
                int c = iter.next();
                if (c < 48 || c > 55) {
                    EXPathBinaryFunctionSet.error("Wrong character in base 8 binary constructor string:" + c, EXPathBinaryFunctionSet.ERROR_NON_NUMERIC_CHAR);
                }
                binary.append((c & 4) == 0 ? "0" : "1");
                binary.append((c & 2) == 0 ? "0" : "1");
                binary.append((c & 1) == 0 ? "0" : "1");
            }
            return EXPathBinaryFunctionSet.inputNumber(binary.toString(), 2, 1);
        }
    }

    public static class BinaryNot
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            int len = value.getLengthInOctets();
            byte[] in = value.getBinaryValue();
            byte[] result = new byte[len];
            int i = 0;
            while (i < len) {
                result[i] = ~in[i++];
            }
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryLength
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            return new Int64Value(value.getLengthInOctets());
        }
    }

    public static class BinaryJoin
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue bv;
            int len = 0;
            GroundedValue input = arguments[0].materialize();
            SequenceIterator iter = input.iterate();
            while ((bv = (Base64BinaryValue)iter.next()) != null) {
                len += bv.getLengthInOctets();
            }
            byte[] result = new byte[len];
            int i = 0;
            iter = input.iterate();
            while ((bv = (Base64BinaryValue)iter.next()) != null) {
                int lb = bv.getLengthInOctets();
                System.arraycopy(bv.getBinaryValue(), 0, result, i, lb);
                i += lb;
            }
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryInsertBefore
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            int valLen = value.getLengthInOctets();
            IntegerValue offsetValue = (IntegerValue)arguments[1].head();
            int off = (int)offsetValue.longValue();
            Base64BinaryValue extra = (Base64BinaryValue)arguments[2].head();
            if (extra == null) {
                return value;
            }
            EXPathBinaryFunctionSet.checkIndexInclusive(value, off, 0);
            int extraLen = extra.getLengthInOctets();
            byte[] result = new byte[valLen + extraLen];
            System.arraycopy(value.getBinaryValue(), 0, result, 0, off);
            System.arraycopy(extra.getBinaryValue(), 0, result, off, extraLen);
            System.arraycopy(value.getBinaryValue(), off, result, off + extraLen, valLen - off);
            return EXPathBinaryFunctionSet.one(result);
        }
    }

    public static class BinaryHex
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            StringValue s = (StringValue)arguments[0].head();
            if (s == null) {
                return EmptySequence.getInstance();
            }
            return EXPathBinaryFunctionSet.inputNumber(s.getStringValue(), 16, 4);
        }
    }

    public static class BinaryFromOctets
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Item item;
            GroundedValue gv = arguments[0].materialize();
            byte[] bytes = new byte[gv.getLength()];
            SequenceIterator iter = gv.iterate();
            int i = 0;
            while ((item = iter.next()) != null) {
                long v = ((IntegerValue)item).longValue();
                if (0L <= v && v <= 255L) {
                    bytes[i++] = (byte)v;
                    continue;
                }
                EXPathBinaryFunctionSet.error("Integer outside octet range in binary constructor:" + v, EXPathBinaryFunctionSet.ERROR_OCTET_RANGE);
            }
            return EXPathBinaryFunctionSet.one(bytes);
        }
    }

    public static class BinaryFind
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            IntegerValue offsetValue = (IntegerValue)arguments[1].head();
            int off = (int)offsetValue.longValue();
            Base64BinaryValue search = (Base64BinaryValue)arguments[2].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            byte[] in = value.getBinaryValue();
            if (search.getLengthInOctets() == 0) {
                return offsetValue;
            }
            EXPathBinaryFunctionSet.checkIndex(value, off, 0);
            byte[] s = search.getBinaryValue();
            int i = EXPathBinaryFunctionSet.find(in, s, off);
            if (i == -1) {
                return EmptySequence.getInstance();
            }
            return new Int64Value(i);
        }
    }

    public static class BinaryEncodeString
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            byte[] data;
            StringValue value = (StringValue)arguments[0].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            String s = value.head().getStringValue();
            String encoding = arguments.length < 2 ? "UTF-8" : arguments[1].head().getStringValue();
            try {
                data = BinaryResource.encode(s, encoding);
            }
            catch (XPathException e) {
                e.setErrorCodeQName(new StructuredQName("bin", ERROR_NAMESPACE, e.getMessage().startsWith("Unsupported encoding") ? EXPathBinaryFunctionSet.ERROR_UNKNOWN_ENCODING : EXPathBinaryFunctionSet.ERROR_CONVERSION));
                throw e;
            }
            return EXPathBinaryFunctionSet.one(data);
        }
    }

    public static class BinaryDecodeString
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value = (Base64BinaryValue)arguments[0].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            String encoding = arguments.length < 2 ? "UTF-8" : arguments[1].head().getStringValue();
            int offset = arguments.length < 3 ? 0 : (int)((NumericValue)arguments[2].head()).longValue();
            int len = arguments.length < 4 ? value.getLengthInOctets() - offset : (int)((NumericValue)arguments[3].head()).longValue();
            EXPathBinaryFunctionSet.checkIndexInclusive(value, offset, len);
            try {
                String result = BinaryResource.decode(value.getBinaryValue(), offset, len, encoding);
                return new StringValue(result);
            }
            catch (XPathException e) {
                e.setErrorCodeQName(new StructuredQName("bin", ERROR_NAMESPACE, e.getMessage().startsWith("Unsupported encoding") ? EXPathBinaryFunctionSet.ERROR_UNKNOWN_ENCODING : EXPathBinaryFunctionSet.ERROR_CONVERSION));
                throw e;
            }
        }
    }

    public static class BinaryBin
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            StringValue s = (StringValue)arguments[0].head();
            if (s == null) {
                return EmptySequence.getInstance();
            }
            return EXPathBinaryFunctionSet.inputNumber(s.getStringValue(), 2, 1);
        }
    }

    public static class BinaryAnd
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Base64BinaryValue value1 = (Base64BinaryValue)arguments[0].head();
            Base64BinaryValue value2 = (Base64BinaryValue)arguments[1].head();
            if (value1 == null || value2 == null) {
                return EmptySequence.getInstance();
            }
            EXPathBinaryFunctionSet.checkSameLength(value1, value2);
            int len = value1.getLengthInOctets();
            byte[] in1 = value1.getBinaryValue();
            byte[] in2 = value2.getBinaryValue();
            byte[] result = new byte[value1.getLengthInOctets()];
            for (int i = 0; i < len; ++i) {
                result[i] = (byte)(in1[i] & in2[i]);
            }
            return EXPathBinaryFunctionSet.one(result);
        }
    }
}

