/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntIterator;

public class DecodeFromURI
extends SystemFunction {
    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        if (arguments[0].head() == null) {
            return new StringValue("");
        }
        String value = arguments[0].head().getStringValue();
        if (value.isEmpty()) {
            return new StringValue("");
        }
        return new StringValue(DecodeFromURI.decode(value));
    }

    private static boolean isHex(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F';
    }

    public static String decode(String value) {
        ArrayList<Byte> output = new ArrayList<Byte>();
        byte[] octets = value.getBytes(StandardCharsets.UTF_8);
        int idx = 0;
        block4: while (idx < octets.length) {
            switch ((char)octets[idx]) {
                case '+': {
                    output.add((byte)32);
                    ++idx;
                    continue block4;
                }
                case '%': {
                    if (idx + 2 >= octets.length) {
                        output.add((byte)-17);
                        output.add((byte)-65);
                        output.add((byte)-67);
                        idx = octets.length;
                        continue block4;
                    }
                    char tens = Character.toUpperCase((char)(octets[idx + 1] & 0xFF));
                    char ones = Character.toUpperCase((char)(octets[idx + 2] & 0xFF));
                    idx += 3;
                    if (DecodeFromURI.isHex(tens) && DecodeFromURI.isHex(ones)) {
                        int hex = Integer.parseInt("" + tens + ones, 16);
                        output.add((byte)hex);
                        continue block4;
                    }
                    output.add((byte)-17);
                    output.add((byte)-65);
                    output.add((byte)-67);
                    continue block4;
                }
            }
            output.add(octets[idx]);
            ++idx;
        }
        byte[] utf8 = new byte[output.size()];
        for (idx = 0; idx < output.size(); ++idx) {
            utf8[idx] = (Byte)output.get(idx);
        }
        UnicodeString result = StringView.of(new String(utf8, StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        IntIterator iter = result.codePoints();
        while (iter.hasNext()) {
            int cp = iter.next();
            if (XMLCharacterData.isValid10(cp)) {
                sb.appendCodePoint(cp);
                continue;
            }
            sb.appendCodePoint(65533);
        }
        return sb.toString();
    }
}

