/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.cmd;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import lemming.lemma.Lemmatizer;
import marmot.core.Sequence;
import marmot.morph.MorphDictionary;
import marmot.morph.MorphOptions;
import marmot.morph.MorphTagger;
import marmot.morph.MorphWeightVector;
import marmot.morph.Sentence;
import marmot.morph.Word;
import marmot.morph.io.SentenceReader;
import marmot.util.FileUtils;
import marmot.util.Sys;

public class Annotator {
    private static final char SEPARATOR_ = '\t';
    private static final String EMPTY_ = "_";

    public static void main(String[] args2) {
        String lemmatizer_file;
        MorphOptions options = new MorphOptions();
        options.setPropertiesFromStrings(args2);
        options.dieIfPropertyIsEmpty("model-file");
        options.dieIfPropertyIsEmpty("pred-file");
        options.dieIfPropertyIsEmpty("test-file");
        MorphTagger tagger = (MorphTagger)FileUtils.loadFromFile(options.getModelFile());
        if (options.getFormatIsCoNLLU()) {
            tagger.setFormat("conllu");
        }
        if (!(lemmatizer_file = options.getLemmatizerFile()).isEmpty()) {
            Lemmatizer lemmatizer = (Lemmatizer)FileUtils.loadFromFile(lemmatizer_file);
            tagger.setPipeLineLemmatizer(lemmatizer);
        }
        if (options.getVerbose()) {
            System.err.format("Loaded model, currently using %g MB of RAM\n", Sys.getUsedMemoryInMegaBytes());
        }
        if (!options.getMorphDict().isEmpty()) {
            MorphWeightVector vector = (MorphWeightVector)tagger.getWeightVector();
            MorphDictionary dict = vector.getMorphDict();
            if (dict != null) {
                dict.addWordsFromFile(options.getMorphDict());
            } else {
                System.err.format("Warning: Can't add words from morph. dictionary, because morph. dictionary is null!\n", new Object[0]);
            }
        }
        try {
            String pred_file = options.getPredFile();
            Writer writer = pred_file.isEmpty() ? new BufferedWriter(new OutputStreamWriter(System.out)) : FileUtils.openFileWriter(pred_file);
            Annotator.annotate(tagger, options.getTestFile(), writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void annotate(MorphTagger tagger, String text_file, Writer writer) throws IOException {
        SentenceReader reader = new SentenceReader(text_file);
        for (Sequence sequence : reader) {
            Annotator.annotate(tagger, sequence, writer);
        }
    }

    public static void annotate(MorphTagger tagger, Sequence sequence, Writer writer) throws IOException {
        List<List<String>> lemma_tags;
        Sentence sentence = (Sentence)sequence;
        if (sentence.isEmpty()) {
            System.err.println("Warning: Skipping empty sentence!");
            return;
        }
        List<String> comments = sentence.getComments();
        for (String comment : comments) {
            writer.append(comment + "\n");
        }
        try {
            lemma_tags = tagger.tagWithLemma(sentence);
        }
        catch (OutOfMemoryError e) {
            lemma_tags = new ArrayList<List<String>>(sentence.size());
            List<String> lemma_tag = Arrays.asList(EMPTY_, EMPTY_);
            for (int index = 0; index < sentence.size(); ++index) {
                lemma_tags.add(lemma_tag);
            }
            System.err.format("Warning: Can't tag sentence of length: %d (Not enough memory)!\n", sentence.size());
        }
        Hashtable<Integer, String> segments = sentence.getSegments();
        Hashtable<Integer, String> empty_nodes = sentence.getEmptyNodes();
        for (int i = 0; i < sentence.size(); ++i) {
            Word word = sentence.getWord(i);
            List<String> token_lemma_tags = lemma_tags.get(i);
            if (segments.containsKey(i + 1)) {
                writer.append(segments.get(i + 1));
                for (int j = 0; j < 8; ++j) {
                    writer.append('\t');
                    writer.append(EMPTY_);
                }
                writer.append('\n');
            }
            if (tagger.getFormat() == 1) {
                writer.append(Integer.toString(i + 1));
                writer.append('\t');
                writer.append(word.getWordForm());
                writer.append('\t');
                lemma = token_lemma_tags.get(0);
                if (word.getLemma() != null) {
                    writer.append(word.getLemma());
                } else {
                    writer.append(Objects.requireNonNullElse(lemma, EMPTY_));
                }
                writer.append('\t');
                pos = token_lemma_tags.get(1);
                if (word.getPosTag() != null) {
                    writer.append(word.getPosTag());
                } else {
                    writer.append(Objects.requireNonNullElse(pos, EMPTY_));
                }
                writer.append('\t');
                writer.append(EMPTY_);
                writer.append('\t');
                morph = EMPTY_;
                if (word.getMorphTag() != null) {
                    writer.append(word.getMorphTag());
                } else if (2 < token_lemma_tags.size()) {
                    morph = token_lemma_tags.get(2);
                    writer.append(morph);
                } else {
                    writer.append(EMPTY_);
                }
                writer.append('\t');
                writer.append(EMPTY_);
                writer.append('\t');
                writer.append(EMPTY_);
                writer.append('\t');
                writer.append(EMPTY_);
                writer.append('\t');
                writer.append(EMPTY_);
            } else {
                writer.append(Integer.toString(i + 1));
                writer.append('\t');
                writer.append(word.getWordForm());
                writer.append('\t');
                writer.append(word.getLemma() != null ? word.getLemma() : EMPTY_);
                writer.append('\t');
                lemma = token_lemma_tags.get(0);
                writer.append(lemma != null ? lemma : EMPTY_);
                writer.append('\t');
                writer.append(word.getPosTag() != null ? word.getPosTag() : EMPTY_);
                writer.append('\t');
                pos = token_lemma_tags.get(1);
                writer.append(pos);
                writer.append('\t');
                writer.append(word.getMorphTag() != null ? word.getMorphTag() : EMPTY_);
                writer.append('\t');
                morph = EMPTY_;
                if (2 < token_lemma_tags.size()) {
                    morph = token_lemma_tags.get(2);
                }
                writer.append(morph);
            }
            writer.append('\n');
            if (!empty_nodes.containsKey(i + 1)) continue;
            writer.append(empty_nodes.get(i + 1));
            writer.append('\n');
        }
        writer.append('\n');
    }
}

