/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.InsertAction;
import com.saxonica.ee.update.InsertAttributeAction;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.validate.SkipValidator;
import com.saxonica.ee.xtupdate.SaxonInsert;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.UpdateElaborator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class InsertExpression
extends BasicUpdatingExpression {
    private final int position;
    private final int constructionMode;
    private final boolean inheritNamespaces;
    private final boolean preserveNamespaces;
    private final Operand sourceOp;
    private final Operand targetOp;

    public InsertExpression(Expression source, Expression target, int position, int constructionMode, boolean inherit, boolean preserve) {
        this.sourceOp = new Operand(this, source, OperandRole.SINGLE_ATOMIC);
        this.targetOp = new Operand(this, target, OperandRole.INSPECT);
        this.position = position;
        this.constructionMode = constructionMode;
        this.inheritNamespaces = inherit;
        this.preserveNamespaces = preserve;
    }

    public Expression getSourceExpression() {
        return this.sourceOp.getChildExpression();
    }

    public void setSourceExpression(Expression sourceExpression) {
        this.sourceOp.setChildExpression(sourceExpression);
    }

    public Expression getTargetExpression() {
        return this.targetOp.getChildExpression();
    }

    public void setTargetExpression(Expression targetExpression) {
        this.targetOp.setChildExpression(targetExpression);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.sourceOp, this.targetOp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        Supplier<RoleDiagnostic> roleSupplier0 = () -> {
            RoleDiagnostic role0 = new RoleDiagnostic(10, "insert", 1);
            role0.setErrorCode("XUDY0027");
            return role0;
        };
        this.setTargetExpression(tc.staticTypeCheck(this.getTargetExpression(), SequenceType.NON_EMPTY_SEQUENCE, roleSupplier0, visitor));
        Supplier<RoleDiagnostic> roleSupplier1 = () -> {
            RoleDiagnostic role0 = new RoleDiagnostic(10, "insert", 1);
            role0.setErrorCode(this.position == 133 || this.position == 134 ? "XUTY0006" : "XUTY0005");
            return role0;
        };
        this.setTargetExpression(tc.staticTypeCheck(this.getTargetExpression(), SequenceType.OPTIONAL_NODE, roleSupplier1, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        InsertExpression exp = new InsertExpression(this.getSourceExpression().copy(rebindings), this.getTargetExpression().copy(rebindings), this.position, this.constructionMode, this.inheritNamespaces, this.preserveNamespaces);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public String getExpressionName() {
        return "insert";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("insert", this);
        out.emitAttribute("position", SaxonInsert.encodePosition(this.position));
        out.emitAttribute("constructionMode", this.constructionMode + "");
        StringBuilder fsb = new StringBuilder(2);
        if (this.inheritNamespaces) {
            fsb.append("i");
        }
        if (this.preserveNamespaces) {
            fsb.append("p");
        }
        out.emitAttribute("flags", fsb.toString());
        this.getSourceExpression().export(out);
        this.getTargetExpression().export(out);
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new InsertExpressionElaborator();
    }

    private static class InsertExpressionElaborator
    extends UpdateElaborator {
        private InsertExpressionElaborator() {
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            InsertExpression expr = (InsertExpression)this.getExpression();
            ItemEvaluator targetEval = expr.getTargetExpression().makeElaborator().elaborateForItem();
            PullEvaluator sourceEval = expr.getSourceExpression().makeElaborator().elaborateForPull();
            return (context, pul) -> {
                Item item;
                NodeInfo parent;
                ArrayList<Item> content = new ArrayList<Item>();
                NodeInfo target = (NodeInfo)targetEval.eval(context);
                if (target == null) {
                    throw new XPathException("Target of insert expression must not be empty", "XUDY0027").withLocation(expr.getLocation()).withXPathContext(context);
                }
                int kind = target.getNodeKind();
                if (expr.position == 133 || expr.position == 134) {
                    if (kind != 1 && kind != 3 && kind != 8 && kind != 7) {
                        throw new XPathException("When inserting before or after a node, that node must be an element, text, comment, or processing-instruction node", "XUTY0006").withLocation(expr.getLocation()).withXPathContext(context);
                    }
                } else if (kind != 1 && kind != 9) {
                    throw new XPathException("When inserting into a target node, that node must be an element or document node", "XUTY0005").withLocation(expr.getLocation()).withXPathContext(context);
                }
                NodeInfo nodeInfo = parent = expr.position == 133 || expr.position == 134 ? target.getParent() : target;
                if (parent == null) {
                    throw new XPathException("When inserting before or after a node, that node must have a parent", "XUDY0029").withLocation(expr.getLocation()).withXPathContext(context);
                }
                if (!(parent instanceof MutableNodeInfo)) {
                    throw new XPathException("Target node of insert expression is not updatable", "SXUP0081").withLocation(expr.getLocation()).withXPathContext(context);
                }
                boolean foundNonAttribute = false;
                SequenceIterator iter = sourceEval.iterate(context);
                while ((item = iter.next()) != null) {
                    if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 2) {
                        SimpleType attributeType;
                        if (foundNonAttribute) {
                            throw new XPathException("Attributes must precede non-attributes in the list of nodes to be inserted", "XUTY0004").withLocation(expr.getLocation()).withXPathContext(context);
                        }
                        if (parent.getNodeKind() != 1) {
                            if (expr.position == 133 || expr.position == 134) {
                                throw new XPathException("When inserting an attribute before or after a node, that node must have a parent and the parent must be an element", "XUDY0030").withLocation(expr.getLocation()).withXPathContext(context);
                            }
                            throw new XPathException("When inserting an attribute into a target node, the target node must be an element", "XUTY0022").withLocation(expr.getLocation()).withXPathContext(context);
                        }
                        NodeInfo copiedNode = (NodeInfo)item;
                        int properties = 0;
                        if (expr.constructionMode == 4 || Untyped.getInstance().equals(parent.getSchemaType())) {
                            attributeType = BuiltInAtomicType.UNTYPED_ATOMIC;
                        } else {
                            attributeType = (SimpleType)copiedNode.getSchemaType();
                            if (copiedNode.isId() || "id".equals(copiedNode.getLocalPart()) && NamespaceUri.XML.equals(copiedNode.getNamespaceUri())) {
                                properties |= 0x800;
                            }
                            if (copiedNode.isIdref()) {
                                properties |= 0x1000;
                            }
                        }
                        try {
                            InsertAttributeAction action = new InsertAttributeAction((MutableNodeInfo)parent, NameOfNode.makeName(copiedNode), attributeType, copiedNode.getStringValue(), properties, expr.inheritNamespaces);
                            action.setOriginator(expr);
                            ((PendingUpdateListImpl)pul).add(action);
                            continue;
                        }
                        catch (XPathException e) {
                            throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                        }
                    }
                    foundNonAttribute = true;
                    content.add(item);
                }
                if (!content.isEmpty()) {
                    Builder builder = ((MutableNodeInfo)parent).newBuilder();
                    Controller controller = context.getController();
                    builder.setLineNumbering(controller.getConfiguration().isLineNumbering());
                    PipelineConfiguration pipe = controller.makePipelineConfiguration();
                    pipe.setHostLanguage(expr.getPackageData().getHostLanguage());
                    pipe.setXPathContext(context);
                    builder.setPipelineConfiguration(pipe);
                    Receiver r = builder;
                    if (expr.constructionMode == 4 || Untyped.getInstance().equals(parent.getSchemaType())) {
                        r = new SkipValidator(r);
                    }
                    TreeReceiver out = new TreeReceiver(r);
                    out.setPipelineConfiguration(pipe);
                    out.open();
                    out.startDocument(0);
                    int copyNs = expr.preserveNamespaces ? 524288 : 0;
                    for (Item n : content) {
                        out.append(n, Loc.NONE, copyNs);
                    }
                    out.endDocument();
                    out.close();
                    NodeInfo root = builder.getCurrentRoot();
                    AxisIterator top = root.iterateAxis(3);
                    SequenceExtent.Of<Item> extent = SequenceExtent.from(top);
                    int len = extent.getLength();
                    NodeInfo[] array = new NodeInfo[len];
                    for (int i = 0; i < len; ++i) {
                        array[i] = (NodeInfo)extent.itemAt(i);
                    }
                    InsertAction action = new InsertAction(array, (MutableNodeInfo)target, expr.position, expr.inheritNamespaces);
                    action.setOriginator(expr);
                    ((PendingUpdateListImpl)pul).add(action);
                }
            };
        }
    }
}

