/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.util.Objects;

public class Event {
    private final String outcome;
    private final String[] context;
    private final float[] values;

    public Event(String outcome, CharSequence[] context) {
        this(outcome, context, null);
    }

    public Event(String outcome, String[] context, float[] values2) {
        this.outcome = Objects.requireNonNull(outcome, "outcome must not be null");
        this.context = Objects.requireNonNull(context, "context must not be null");
        this.values = values2;
    }

    public Event(String outcome, CharSequence[] context, float[] values2) {
        this.outcome = Objects.requireNonNull(outcome, "outcome must not be null");
        String[] ctx = new String[context.length];
        for (int i = 0; i < context.length; ++i) {
            ctx[i] = context[i].toString();
        }
        this.context = ctx;
        this.values = values2;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String[] getContext() {
        return this.context;
    }

    public float[] getValues() {
        return this.values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.outcome).append(" [");
        if (this.context.length > 0) {
            sb.append(this.context[0]);
            if (this.values != null) {
                sb.append("=").append(this.values[0]);
            }
        }
        for (int ci = 1; ci < this.context.length; ++ci) {
            sb.append(" ").append(this.context[ci]);
            if (this.values == null) continue;
            sb.append("=").append(this.values[ci]);
        }
        sb.append("]");
        return sb.toString();
    }
}

