/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.util.Properties;
import javax.xml.transform.Result;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class SaxonDeepEqual
extends SystemFunction {
    @Override
    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        String collation;
        String flags = arguments[3].head().getStringValue();
        if (flags.indexOf(33) >= 0) {
            Logger err = context.getConfiguration().getLogger();
            Properties indent = new Properties();
            indent.setProperty("method", "xml");
            indent.setProperty("indent", "yes");
            err.info("DeepEqual: first argument:");
            QueryResult.serialize(QueryResult.wrap(arguments[0].iterate(), context.getConfiguration()), (Result)err.asStreamResult(), indent);
            err.info("DeepEqual: second argument:");
            QueryResult.serialize(QueryResult.wrap(arguments[1].iterate(), context.getConfiguration()), (Result)err.asStreamResult(), indent);
        }
        Item collationValue = arguments[2].head();
        Configuration config = context.getConfiguration();
        StringCollator collator = config.getCollation(collation = collationValue == null ? config.getDefaultCollationName() : collationValue.getStringValue());
        if (collator == null) {
            throw new XPathException("Unknown collation " + collation, "FOCH0002");
        }
        GenericAtomicComparer comparer = new GenericAtomicComparer(collator, context);
        int flag = 0;
        if (flags.contains("N")) {
            flag |= 1;
        }
        if (flags.contains("J")) {
            flag |= 0x100;
        }
        if (flags.contains("C")) {
            flag |= 4;
        }
        if (flags.contains("P")) {
            flag |= 8;
        }
        if (flags.contains("F")) {
            flag |= 2;
        }
        if (flags.contains("S")) {
            flag |= 0x20;
        }
        if (flags.contains("A")) {
            flag |= 0x40;
        }
        if (flags.contains("I")) {
            flag |= 0x200;
        }
        if (flags.contains("v")) {
            flag |= 0x400;
        }
        if (flags.contains("w")) {
            flag |= 0x10;
        }
        if (flags.contains("?")) {
            flag |= 0x80;
        }
        boolean result = DeepEqual.deepEqual(arguments[0].iterate(), arguments[1].iterate(), comparer, context, flag);
        return BooleanValue.get(result);
    }
}

