/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SpanElementQuery;
import de.ids_mannheim.korap.query.spans.WithinSpans;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanWithinQuery
extends SpanQuery
implements Cloneable {
    private SpanQuery wrap;
    private SpanQuery embedded;
    public String field;
    private byte flag;
    private boolean collectPayloads;
    public static final byte OVERLAP = 0;
    public static final byte REAL_OVERLAP = 2;
    public static final byte WITHIN = 4;
    public static final byte REAL_WITHIN = 6;
    public static final byte ENDSWITH = 8;
    public static final byte STARTSWITH = 10;
    public static final byte MATCH = 12;

    public SpanWithinQuery(SpanQuery wrap, SpanQuery embedded, byte flag, boolean collectPayloads) {
        this.field = embedded.getField();
        this.embedded = embedded;
        this.wrap = wrap;
        this.flag = flag;
        this.collectPayloads = collectPayloads;
    }

    public SpanWithinQuery(String element, SpanQuery embedded) {
        this(element, embedded, 4, true);
    }

    public SpanWithinQuery(String element, SpanQuery embedded, byte flag, boolean collectPayloads) {
        this(new SpanElementQuery(embedded.getField(), element), embedded, flag, collectPayloads);
    }

    public SpanWithinQuery(String element, SpanQuery embedded, byte flag) {
        this(element, embedded, flag, true);
    }

    public SpanWithinQuery(String element, SpanQuery embedded, boolean collectPayloads) {
        this(element, embedded, 4, collectPayloads);
    }

    public SpanWithinQuery(SpanQuery wrap, SpanQuery embedded, byte flag) {
        this(wrap, embedded, flag, true);
    }

    public SpanWithinQuery(SpanQuery wrap, SpanQuery embedded) {
        this(wrap, embedded, 4, true);
    }

    @Override
    public String getField() {
        return this.field;
    }

    public SpanQuery wrap() {
        return this.wrap;
    }

    public SpanQuery embedded() {
        return this.embedded;
    }

    public byte flag() {
        return this.flag;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.embedded.extractTerms(terms);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("span");
        buffer.append(this.flagToString());
        buffer.append("(");
        buffer.append(this.wrap.toString());
        buffer.append(", ");
        buffer.append(this.embedded.toString(field));
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    private String flagToString() {
        switch (this.flag) {
            case 0: {
                return "Overlap";
            }
            case 2: {
                return "OverlapStrict";
            }
            case 4: {
                return "Contain";
            }
            case 6: {
                return "ContainStrict";
            }
            case 8: {
                return "EndsWith";
            }
            case 10: {
                return "StartsWith";
            }
            case 12: {
                return "Match";
            }
        }
        return "Contains";
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new WithinSpans(this, context, acceptDocs, termContexts, this.flag);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanWithinQuery clone = null;
        SpanQuery query = (SpanQuery)this.embedded.rewrite(reader);
        if (query != this.embedded) {
            if (clone == null) {
                clone = this.clone();
            }
            clone.embedded = query;
        }
        if ((query = (SpanQuery)this.wrap.rewrite(reader)) != this.wrap) {
            if (clone == null) {
                clone = this.clone();
            }
            clone.wrap = query;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public SpanWithinQuery clone() {
        SpanWithinQuery spanWithinQuery = new SpanWithinQuery((SpanQuery)this.wrap.clone(), (SpanQuery)this.embedded.clone(), this.flag, this.collectPayloads);
        spanWithinQuery.setBoost(this.getBoost());
        return spanWithinQuery;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanWithinQuery)) {
            return false;
        }
        SpanWithinQuery spanWithinQuery = (SpanWithinQuery)o;
        if (this.collectPayloads != spanWithinQuery.collectPayloads) {
            return false;
        }
        if (!this.wrap.equals(spanWithinQuery.wrap)) {
            return false;
        }
        if (!this.embedded.equals(spanWithinQuery.embedded)) {
            return false;
        }
        return this.getBoost() == spanWithinQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int result = this.flag;
        result = this.embedded.hashCode();
        result += this.wrap.hashCode();
        result ^= result << 4 | result >>> 29;
        return result += Float.floatToRawIntBits(this.getBoost());
    }
}

