/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.server;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import de.ids_mannheim.korap.KrillIndex;
import de.ids_mannheim.korap.util.KrillProperties;
import jakarta.ws.rs.core.UriBuilder;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.LogManager;
import org.apache.lucene.store.MMapDirectory;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Node {
    private static UriBuilder BASE_URI;
    private static String propFile;
    private static int port;
    private static String path;
    private static String name;
    private static final Logger log;
    private static KrillIndex index;
    private static ComboPooledDataSource cpds;
    private static String dbUser;
    private static String dbPwd;
    private static String dbClass;
    private static String dbURL;

    public static HttpServer startServer(String[] argv) {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.install();
        block16: for (int i = 0; i < argv.length; i += 2) {
            switch (argv[i]) {
                case "--config": 
                case "-cfg": {
                    propFile = argv[i + 1];
                    continue block16;
                }
                case "--port": 
                case "-p": {
                    port = Integer.valueOf(argv[i + 1]);
                    continue block16;
                }
                case "--name": 
                case "-n": {
                    name = argv[i + 1];
                    continue block16;
                }
                case "--dir": 
                case "-d": {
                    path = argv[i + 1];
                }
            }
        }
        Properties prop = KrillProperties.loadProperties(propFile);
        path = path != null && path.equals(":memory:") ? null : prop.getProperty("krill.indexDir", path);
        if (name.equals("unknown")) {
            name = prop.getProperty("krill.server.name", name);
        }
        BASE_URI = UriBuilder.fromUri(prop.getProperty("krill.server.baseURI", "http://localhost:9876/"));
        if (port != -1) {
            BASE_URI.port(port);
        }
        dbUser = prop.getProperty("krill.db.user", dbUser);
        dbPwd = prop.getProperty("krill.db.pwd", dbPwd);
        dbClass = prop.getProperty("krill.db.class", dbClass);
        dbURL = prop.getProperty("krill.db.jdbcURL", dbURL);
        ResourceConfig rc = new ResourceConfig().packages("de.ids_mannheim.korap.server");
        return GrizzlyHttpServerFactory.createHttpServer(BASE_URI.build(new Object[0]), rc);
    }

    public static void main(String[] argv) throws IOException {
        final HttpServer server = Node.startServer(argv);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Stop Server");
                server.stop();
                if (cpds != null) {
                    cpds.close();
                }
            }
        }, "shutdownHook"));
        try {
            server.start();
            System.out.println("\nHello. My name is " + Node.getName() + " and I am a Krill node");
            System.out.println("listening on " + Node.getListener() + ".");
            Thread.currentThread().join();
        }
        catch (Exception e) {
            log.error("Unable to start server: {}", (Object)e.getLocalizedMessage());
        }
    }

    public static String getName() {
        return name;
    }

    public static String getListener() {
        return Node.getBaseURI().toString();
    }

    public static URI getBaseURI() {
        return BASE_URI.build(new Object[0]);
    }

    public static void closeDBPool() {
        if (cpds != null) {
            cpds.close();
        }
    }

    public static ComboPooledDataSource getDBPool() {
        if (cpds != null) {
            return cpds;
        }
        try {
            cpds = new ComboPooledDataSource();
            cpds.setDriverClass(dbClass);
            cpds.setJdbcUrl(dbURL);
            if (dbUser != null) {
                cpds.setUser(dbUser);
            }
            if (dbPwd != null) {
                cpds.setPassword(dbPwd);
            }
            cpds.setMaxStatements(100);
            return cpds;
        }
        catch (PropertyVetoException e) {
            log.error(e.getLocalizedMessage());
            return null;
        }
    }

    public static KrillIndex getIndex() {
        if (index != null) {
            return index;
        }
        try {
            if (path == null) {
                index = new KrillIndex();
            } else {
                Path file = Paths.get(path, new String[0]);
                log.info("Loading index from {}", (Object)path);
                if (!file.toFile().exists()) {
                    log.error("Index not found at {}", (Object)path);
                    return null;
                }
                index = new KrillIndex(new MMapDirectory(file));
            }
            return index;
        }
        catch (IOException e) {
            log.error("Index not loadable at {}: {}", (Object)path, (Object)e.getMessage());
            return null;
        }
    }

    static {
        propFile = "krill.properties";
        port = -1;
        path = null;
        name = "unknown";
        log = LoggerFactory.getLogger(Node.class);
        dbClass = "org.sqlite.JDBC";
        dbURL = "jdbc:sqlite:";
    }
}

