/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.util.Set;
import marmot.morph.HashDictionary;
import marmot.morph.MorphDictionaryOptions;
import marmot.util.CollectableSet;
import marmot.util.LineIterator;
import marmot.util.StringUtils;
import marmot.util.SymbolTable;
import marmot.util.Trie;

public class SuffixDictionary
extends HashDictionary {
    private static final long serialVersionUID = 1L;
    private Trie<CollectableSet> trie_;

    public SuffixDictionary() {
        this(null);
    }

    public SuffixDictionary(SymbolTable<String> table) {
        super(table);
    }

    @Override
    public int[] getIndexes(String word_form) {
        int[] indexes = super.getIndexes(word_form);
        if (indexes == null) {
            CollectableSet cset;
            word_form = StringUtils.normalize(word_form, this.getOptions().getNormalize());
            if (this.getOptions().getReverse()) {
                word_form = StringUtils.reverse(word_form);
            }
            if ((cset = this.trie_.getContent(word_form)) != null) {
                Set<Object> set = cset.getValue();
                indexes = this.toArray(set);
            }
        }
        return indexes;
    }

    private int[] toArray(Set<Object> set) {
        int[] array = new int[set.size()];
        int i = 0;
        for (Object o : set) {
            array[i++] = (Integer)o;
        }
        return array;
    }

    @Override
    public void init(MorphDictionaryOptions options) {
        super.init(options);
        LineIterator iterator2 = new LineIterator(options.getFilename());
        this.trie_ = new Trie();
        int[] row_indexes = options.getIndexes();
        SymbolTable<String> table = this.getTable();
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (line.isEmpty()) continue;
            String form = (String)line.get(0);
            form = StringUtils.normalize(form, options.getNormalize());
            if (options.getReverse()) {
                form = StringUtils.reverse(form);
            }
            Trie<Object> trie = this.trie_.addWord(form, null);
            for (int row_index : row_indexes) {
                if (row_index <= 0 || row_index >= line.size()) continue;
                String tag = (String)line.get(row_index);
                int index = table.toIndex(tag, true);
                trie.add(new CollectableSet(index));
            }
        }
        this.trie_.propagateContent(options.getLimit());
    }
}

