/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.ManualGroupIterator;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.ForEachAdjunct;
import com.saxonica.ee.stream.adjunct.GroupAdjacentTester;
import com.saxonica.ee.stream.adjunct.GroupBoundaryTester;
import com.saxonica.ee.stream.adjunct.GroupEndingTester;
import com.saxonica.ee.stream.adjunct.GroupStartingTester;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.ForEachGroupParallelAction;
import com.saxonica.ee.stream.watch.ForEachGroupPartitionAction;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.value.SequenceExtent;

public class ForEachGroupAdjunct
extends ForEachAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        Pattern pattern;
        ForEachGroup exp = (ForEachGroup)this.getExpression();
        Expression select = exp.getSelectExpression();
        Expression action = exp.getActionExpression();
        Expression key = exp.getGroupingKey();
        byte algorithm = exp.getAlgorithm();
        PostureAndSweep ps = Streamability.getStreamability(select, contextInfo, reasons);
        if (ps.getPosture() == Posture.GROUNDED) {
            return super.computeStreamability(contextInfo, reasons);
        }
        ContextItemStaticInfoEE info2 = new ContextItemStaticInfoEE(select.getItemType(), false, ps.getPosture());
        if (algorithm == 0) {
            if (exp.isInFork()) {
                if (Streamability.getStreamability(key, info2, null).getSweep() != Sweep.MOTIONLESS) {
                    if (reasons != null) {
                        reasons.add("The xsl:for-each-group/@group-by expression is not motionless");
                    }
                    return PostureAndSweep.ROAMING_AND_FREE_RANGING;
                }
            } else {
                if (reasons != null) {
                    reasons.add("The xsl:for-each-group instruction has an @group-by attribute and is not within xsl:fork");
                }
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
        }
        if (algorithm == 1 && Streamability.getStreamability(key, info2, null).getSweep() != Sweep.MOTIONLESS) {
            if (reasons != null) {
                reasons.add("The xsl:for-each-group/@group-adjacent expression is not motionless");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (!(algorithm != 2 && algorithm != 3 || (pattern = (Pattern)key).isMotionless())) {
            if (reasons != null) {
                String s = algorithm == 2 ? "starting-with" : "ending-with";
                reasons.add("The xsl:for-each-group/@group-" + s + " pattern is not motionless");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (exp.getSortKeyDefinitions() != null || select instanceof SortExpression) {
            if (reasons != null) {
                reasons.add("Groups cannot be sorted when streaming");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        Streamability.getStreamability(action, info2, reasons);
        if (Streamability.getPosture(select) == Posture.CRAWLING && Streamability.getSweep(action) == Sweep.CONSUMING) {
            if (reasons != null) {
                reasons.add("The xsl:for-each-group/@select expression has crawling posture (that is, it can select overlapping nodes)");
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        return new PostureAndSweep(Streamability.getPosture(action), Sweep.wider(Streamability.getSweep(select), Streamability.getSweep(action)));
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Configuration config = this.getConfiguration();
        final Expression select = ((ForEachGroup)this.getExpression()).getSelectExpression();
        if (Streamability.getPosture(select) == Posture.GROUNDED) {
            return null;
        }
        final Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, config, null);
        final StreamingAdjunct sa = StreamingAdjunct.makeStreamingAdjunct(config, select);
        final Inversion actionInversion = this.getActionInversion(true);
        if (((ForEachGroup)this.getExpression()).getAlgorithm() == 0) {
            return new WatchMaker(){

                @Override
                public Trigger makeWatch(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
                    ForEachGroupParallelAction actor = new ForEachGroupParallelAction(watchManager, (ForEachGroup)ForEachGroupAdjunct.this.getExpression(), out, context);
                    if (actionInversion != null) {
                        actor.setInversion(actionInversion);
                    }
                    if (selection != null) {
                        return new Trigger(selection, actor, context);
                    }
                    return ((TransmissionAdjunct)sa).makeTransmissionFlow(watchManager, select, actor, context);
                }
            };
        }
        return new WatchMaker(){

            @Override
            public Trigger makeWatch(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
                ForEachGroupPartitionAction actor = new ForEachGroupPartitionAction(watchManager, (ForEachGroup)ForEachGroupAdjunct.this.getExpression(), out, context);
                if (actionInversion != null) {
                    actor.setInversion(actionInversion);
                }
                if (selection != null) {
                    return new Trigger(selection, actor, context);
                }
                return ((TransmissionAdjunct)sa).makeTransmissionFlow(watchManager, select, actor, context);
            }
        };
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        ForEachGroup instruction = (ForEachGroup)this.getExpression();
        if (Streamability.getPosture(instruction.getSelectExpression()) == Posture.GROUNDED) {
            if (instruction.getAlgorithm() == 0) {
                return new GroupedGroundedDistributedFeed(instruction, out, context);
            }
            XPathContextMinor actionContext = context.newMinorContext();
            ManualIterator actionIter = new ManualIterator();
            actionContext.setCurrentIterator(actionIter);
            return new GroupedGroundedFeed(instruction, out, (XPathContext)actionContext);
        }
        Inversion actionInversion = this.getActionInversion(true);
        ForEachGroupPartitionAction actor = new ForEachGroupPartitionAction(watchManager, (ForEachGroup)this.getExpression(), out, context);
        if (actionInversion != null) {
            actor.setInversion(actionInversion);
        }
        return actor;
    }

    public static GroupBoundaryTester makeBoundaryTester(ForEachGroup instruction, XPathContext populationContext) {
        byte algorithm = instruction.getAlgorithm();
        if (algorithm == 1) {
            return new GroupAdjacentTester(instruction, populationContext);
        }
        if (algorithm == 2) {
            return new GroupStartingTester(instruction, populationContext);
        }
        if (algorithm == 3) {
            return new GroupEndingTester(instruction, populationContext);
        }
        throw new AssertionError((Object)"Unsupported grouping algorithm for partitioned streaming");
    }

    private static class GroupedGroundedDistributedFeed
    extends ItemFeed {
        private List<Item<?>> population = new ArrayList();

        public GroupedGroundedDistributedFeed(ForEachGroup instruction, Feed result, XPathContext context) {
            super(instruction, result, context);
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            this.population.add(item);
        }

        @Override
        public void close() throws XPathException {
            ForEachGroup inst = (ForEachGroup)this.getExpression();
            Literal pop = Literal.makeLiteral(SequenceExtent.makeSequenceExtent(this.population), inst);
            GroupIterator groupIterator = inst.getGroupIterator(pop, this.getContext());
            XPathContextMajor c2 = this.getContext().newContext();
            FocusIterator focusIterator = c2.trackFocus(groupIterator);
            c2.setCurrentGroupIterator(groupIterator);
            c2.setCurrentTemplateRule(null);
            c2.setReceiver(this.getResult().getReceiver());
            while (focusIterator.next() != null) {
                inst.getActionExpression().process(c2);
            }
            super.close();
        }
    }

    private static class GroupedGroundedFeed
    extends ItemFeed {
        private List<Item<?>> currentGroup = new ArrayList();
        private int groupCounter = 0;
        private GroupBoundaryTester boundaryTester;
        private AtomicSequence currentGroupingKey;

        public GroupedGroundedFeed(ForEachGroup instruction, Feed result, XPathContext context) {
            super(instruction, result, context);
            this.boundaryTester = ForEachGroupAdjunct.makeBoundaryTester(instruction, context);
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            ManualIterator popIter = (ManualIterator)this.getContext().getCurrentIterator();
            popIter.setContextItem(item);
            popIter.incrementPosition();
            boolean startNewGroup = this.boundaryTester.notifyItem();
            if (startNewGroup) {
                this.processCompletedGroup();
                this.currentGroup.clear();
                ++this.groupCounter;
                if (this.boundaryTester instanceof GroupAdjacentTester) {
                    this.currentGroupingKey = ((GroupAdjacentTester)this.boundaryTester).getCurrentGroupingKey();
                }
            }
            this.currentGroup.add(item);
        }

        @Override
        public void close() throws XPathException {
            this.processCompletedGroup();
            super.close();
        }

        private void processCompletedGroup() throws XPathException {
            if (!this.currentGroup.isEmpty()) {
                XPathContextMajor c2 = this.getContext().newContext();
                ManualIterator popIter = new ManualIterator(this.currentGroup.get(0), this.groupCounter);
                c2.setCurrentIterator(popIter);
                ManualGroupIterator gi = new ManualGroupIterator(this.currentGroup.get(0), 1);
                gi.setCurrentGroup(this.currentGroup);
                gi.setCurrentGroupingKey(this.currentGroupingKey);
                c2.setCurrentGroupIterator(gi);
                c2.setReceiver(ComplexContentOutputter.makeComplexContentReceiver(this.getReceiver(), null));
                ((ForEachGroup)this.getExpression()).getActionExpression().process(c2);
            }
        }
    }
}

