/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import java.util.function.IntPredicate;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextualElement;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.UType;

final class GraftingDescendantIterator
implements AxisIterator {
    private final TinyTree tree;
    private final TinyNodeImpl startNode;
    private int nextNodeNr;
    private final int startDepth;
    private final NodeTest test;
    private final IntPredicate matcher;
    private AxisIterator nestedIterator;
    private NodeInfo pending = null;
    private boolean includeTextNodes;

    GraftingDescendantIterator(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest) {
        this.tree = doc;
        this.startNode = node;
        this.test = nodeTest;
        this.nextNodeNr = node.nodeNr;
        this.startDepth = doc.depth[this.nextNodeNr];
        this.matcher = nodeTest.getMatcher(doc);
        this.includeTextNodes = nodeTest.getUType().overlaps(UType.TEXT);
    }

    @Override
    public NodeInfo next() {
        while (true) {
            if (this.pending != null) {
                NodeInfo p = this.pending;
                this.pending = null;
                return p;
            }
            if (this.nestedIterator != null) {
                NodeInfo nested = this.nestedIterator.next();
                if (nested != null) {
                    return nested;
                }
                this.nestedIterator = null;
            }
            ++this.nextNodeNr;
            try {
                if (this.tree.depth[this.nextNodeNr] <= this.startDepth) {
                    this.nextNodeNr = -1;
                    return null;
                }
                if (this.tree.nodeKind[this.nextNodeNr] == 33) {
                    byte axis = this.nextNodeNr == this.startNode.nodeNr ? (byte)4 : 5;
                    this.nestedIterator = this.tree.externalNodes.get(this.tree.alpha[this.nextNodeNr]).iterateAxis(axis, this.test);
                    continue;
                }
                if (this.includeTextNodes && this.tree.nodeKind[this.nextNodeNr] == 17) {
                    this.pending = ((TinyTextualElement)this.tree.getNode(this.nextNodeNr)).getTextNode();
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.nextNodeNr = -1;
                return null;
            }
            if (this.matcher.test(this.nextNodeNr)) break;
        }
        return this.tree.getNode(this.nextNodeNr);
    }
}

