/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanClassFilterQuery;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import de.ids_mannheim.korap.util.KrillByte;
import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;

public class ClassFilteredSpans
extends SimpleSpans {
    private BitSet bitset1;
    private BitSet bitset2;
    private SpanClassFilterQuery.ClassOperation operation;
    private byte classNum1;
    private byte classNum2;

    public ClassFilteredSpans(SpanClassFilterQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.operation = query.getOperation();
        this.classNum1 = query.getClassNum1();
        this.classNum2 = query.getClassNum2();
        this.hasMoreSpans = this.firstSpans.next();
    }

    @Override
    public boolean next() throws IOException {
        while (this.hasMoreSpans) {
            this.matchPayload.clear();
            this.bitset1 = null;
            this.bitset2 = null;
            if (this.isClassOperationValid()) {
                this.matchStartPosition = this.firstSpans.start();
                this.matchEndPosition = this.firstSpans.end();
                this.matchDocNumber = this.firstSpans.doc();
                this.matchPayload.addAll(this.firstSpans.getPayload());
                this.hasMoreSpans = this.firstSpans.next();
                return true;
            }
            this.hasMoreSpans = this.firstSpans.next();
        }
        return false;
    }

    private boolean isClassOperationValid() throws IOException {
        this.setBitsets();
        int cardinality = Math.max(this.bitset1.cardinality(), this.bitset2.cardinality());
        this.bitset1.and(this.bitset2);
        switch (this.operation) {
            case DISJOINT: {
                if (this.bitset1.cardinality() != 0) break;
                return true;
            }
            case EQUAL: {
                if (cardinality != this.bitset1.cardinality()) break;
                return true;
            }
            case DIFFER: {
                if (cardinality != 0 && cardinality == this.bitset1.cardinality()) break;
                return true;
            }
            case INCLUDE: {
                if (this.bitset1.cardinality() != this.bitset2.cardinality()) break;
                return true;
            }
            case INTERSECT: {
                if (this.bitset1.cardinality() <= 0) break;
                return true;
            }
        }
        return false;
    }

    private void setBitsets() throws IOException {
        BitSet bs = new BitSet();
        for (byte[] payload : this.firstSpans.getPayload()) {
            if (payload[0] != 0) continue;
            int start = KrillByte.byte2int(payload, 1) + 1;
            int end = KrillByte.byte2int(payload, 5) + 1;
            if (payload[9] == this.classNum1) {
                if (this.bitset1 == null) {
                    this.bitset1 = new BitSet();
                    this.bitset1.set(start, end);
                    continue;
                }
                bs.set(start, end);
                this.bitset1.or(bs);
                continue;
            }
            if (payload[9] != this.classNum2) continue;
            if (this.bitset2 == null) {
                this.bitset2 = new BitSet();
                this.bitset2.set(start, end);
                continue;
            }
            bs.set(start, end);
            this.bitset2.or(bs);
        }
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        return false;
    }

    @Override
    public long cost() {
        return 0L;
    }
}

