/*
 * Decompiled with CFR 0.152.
 */
package experimental.ising;

import experimental.ising.Belief;
import experimental.ising.BinaryFactor;
import experimental.ising.Message;
import experimental.ising.UnaryFactor;
import experimental.ising.UnaryFeatureExtractor;
import experimental.ising.Variable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.javatuples.Pair;

public class IsingFactorGraph {
    private String word;
    private int numVariables;
    protected List<Variable> variables;
    protected List<UnaryFactor> unaryFactors;
    protected List<BinaryFactor> binaryFactors;
    protected List<Integer> golden;
    protected int numParameters;
    protected UnaryFeatureExtractor ufe;
    private int inferenceIterations;

    public IsingFactorGraph(String word, UnaryFeatureExtractor ufe, int inferenceIterations, int numVariables, List<Pair<Integer, Integer>> pairwise, List<Integer> golden, List<String> tagNames) {
        this.numVariables = numVariables;
        this.variables = new ArrayList<Variable>();
        this.unaryFactors = new ArrayList<UnaryFactor>();
        this.binaryFactors = new ArrayList<BinaryFactor>();
        this.word = word;
        this.ufe = ufe;
        this.inferenceIterations = inferenceIterations;
        this.golden = golden;
        for (int i = 0; i < this.numVariables; ++i) {
            Variable v = new Variable(2, i, tagNames.get(i));
            UnaryFactor uf = new UnaryFactor(word, tagNames.get(i), 2, i, ufe);
            v.getNeighbors().add(uf);
            v.getMessageIds().add(0);
            v.getMessages().add(new Message(2));
            uf.getNeighbors().add(v);
            uf.getMessageIds().add(v.getMessages().size());
            uf.getMessages().add(new Message(2));
            this.variables.add(v);
            this.unaryFactors.add(uf);
        }
        for (Pair<Integer, Integer> p : pairwise) {
            int i = (Integer)p.getValue0();
            int j = (Integer)p.getValue1();
            BinaryFactor bf = new BinaryFactor(2, 2, i, j);
            Variable v1 = this.variables.get(i);
            Variable v2 = this.variables.get(j);
            v1.getNeighbors().add(bf);
            v1.getMessageIds().add(0);
            bf.getMessages().add(new Message(2));
            v2.getNeighbors().add(bf);
            v2.getMessageIds().add(1);
            bf.getMessages().add(new Message(2));
            bf.getNeighbors().add(v1);
            bf.getMessageIds().add(v1.getMessages().size());
            v1.getMessages().add(new Message(2));
            bf.getNeighbors().add(v2);
            bf.getMessageIds().add(v2.getMessages().size());
            v2.getMessages().add(new Message(2));
            this.binaryFactors.add(bf);
        }
        this.numParameters = 2 * this.unaryFactors.size() + 4 * this.binaryFactors.size();
    }

    public IsingFactorGraph(int numVariables2, List<Pair<Integer, Integer>> pairs, List<Integer> golden2, List<String> tagNames) {
        throw new UnsupportedOperationException();
    }

    public double[][] inferenceBruteForce() {
        double[][] marginals = new double[this.numVariables][2];
        double Z = 0.0;
        int i = 0;
        while ((double)i < Math.pow(2.0, this.numVariables)) {
            int n;
            double configurationScore = 1.0;
            String format = "%0" + this.numVariables + "d";
            String newString = String.format(format, Integer.valueOf(Integer.toBinaryString(i)));
            ArrayList<Integer> configuration = new ArrayList<Integer>();
            for (n = 0; n < this.numVariables; ++n) {
                configuration.add(Character.getNumericValue(newString.charAt(n)));
            }
            for (UnaryFactor uf : this.unaryFactors) {
                int value = (Integer)configuration.get(uf.getI());
                configurationScore *= uf.potential[value];
            }
            for (BinaryFactor bf : this.binaryFactors) {
                int value1 = (Integer)configuration.get(bf.getI());
                int value2 = (Integer)configuration.get(bf.getJ());
                configurationScore *= bf.potential[value1][value2];
            }
            Z += configurationScore;
            for (n = 0; n < this.numVariables; ++n) {
                int value = (Integer)configuration.get(n);
                double[] dArray = marginals[n];
                int n2 = value;
                dArray[n2] = dArray[n2] + configurationScore;
            }
            ++i;
        }
        for (int n = 0; n < this.numVariables; ++n) {
            double Z_local = marginals[n][0] + marginals[n][1];
            double[] dArray = marginals[n];
            dArray[0] = dArray[0] / Z_local;
            double[] dArray2 = marginals[n];
            dArray2[1] = dArray2[1] / Z_local;
        }
        return marginals;
    }

    public double betheFreeEnergy() {
        double betheFreeEnergy = 0.0;
        for (Variable v : this.variables) {
            v.computeBelief();
            UnaryFactor uf = this.unaryFactors.get(v.getI());
            for (int i = 0; i < v.getSize(); ++i) {
                int n = v.getNeighbors().size() - 2;
                if (n != 0) {
                    betheFreeEnergy += (double)n * v.getBelief().measure[i] * Math.log(v.getBelief().measure[i]);
                }
                betheFreeEnergy += v.getBelief().measure[i] * Math.log(uf.potential[i]);
            }
        }
        return betheFreeEnergy;
    }

    public double approximateZ() {
        return Math.exp(this.betheFreeEnergy());
    }

    public void inference(int maxIterNum, double convergence) {
        for (int iterNum = 0; iterNum < maxIterNum; ++iterNum) {
            for (UnaryFactor ur : this.unaryFactors) {
                ur.passMessage();
            }
        }
        for (Variable v : this.variables) {
            v.computeBelief();
        }
    }

    public List<String> viterbiDecode() {
        return null;
    }

    public List<String> posteriorDecode() {
        LinkedList<String> tags = new LinkedList<String>();
        this.inference(this.inferenceIterations, 0.01);
        for (Variable v : this.variables) {
            Belief b = v.getBelief();
            if (!(b.measure[1] > b.measure[0])) continue;
            tags.add(v.getTagName());
        }
        return tags;
    }

    public double logLikelihood() {
        double logZ_B = this.betheFreeEnergy();
        double configurationScore = 1.0;
        for (UnaryFactor uf : this.unaryFactors) {
            int value = this.golden.get(uf.getI());
            configurationScore *= uf.potential[value];
        }
        return Math.log(configurationScore) - logZ_B;
    }

    public double[] finiteDifference(double[] parameters, double epsilon) {
        double[] gradient = new double[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            int n = i;
            parameters[n] = parameters[n] + epsilon;
            this.updatePotentials(parameters);
            this.inference(10, 1.0);
            double val1 = this.logLikelihood();
            int n2 = i;
            parameters[n2] = parameters[n2] - 2.0 * epsilon;
            this.updatePotentials(parameters);
            this.inference(10, 1.0);
            double val2 = this.logLikelihood();
            gradient[i] = (val1 - val2) / (2.0 * epsilon);
            int n3 = i++;
            parameters[n3] = parameters[n3] + epsilon;
        }
        return gradient;
    }

    public void updatePotentials2(double[] parameters) {
        int counter = 0;
        for (UnaryFactor uf : this.unaryFactors) {
            uf.setPotential(0, Math.exp(parameters[counter]));
            uf.setPotential(1, Math.exp(parameters[++counter]));
            ++counter;
        }
        for (BinaryFactor bf : this.binaryFactors) {
            bf.setPotential(0, 0, Math.exp(parameters[counter]));
            bf.setPotential(0, 1, Math.exp(parameters[++counter]));
            bf.setPotential(1, 0, Math.exp(parameters[++counter]));
            bf.setPotential(1, 1, Math.exp(parameters[++counter]));
            ++counter;
        }
    }

    public void updatePotentials(double[] parameters) {
        for (UnaryFactor uf : this.unaryFactors) {
            uf.updatePotential(parameters);
        }
    }

    public void featurizedGradient(double[] gradient, int numData) {
        this.inference(this.inferenceIterations, 0.01);
        for (UnaryFactor uf : this.unaryFactors) {
            if (this.golden.get(uf.getI()) == 1) {
                for (Integer feat : uf.getFeaturesPositive()) {
                    int n = feat;
                    gradient[n] = gradient[n] + 1.0;
                }
            }
            for (Integer feat : uf.getFeaturesPositive()) {
                int n = feat;
                gradient[n] = gradient[n] - this.variables.get((int)uf.getI()).getBelief().measure[1];
            }
            if (this.golden.get(uf.getI()) == 0) {
                for (Integer feat : uf.getFeaturesNegative()) {
                    int n = feat;
                    gradient[n] = gradient[n] + 1.0;
                }
            }
            for (Integer feat : uf.getFeaturesNegative()) {
                int n = feat;
                gradient[n] = gradient[n] - this.variables.get((int)uf.getI()).getBelief().measure[0];
            }
        }
    }

    public double[] unfeaturizedGradient() {
        this.inference(10, 0.01);
        double[] gradient = new double[this.numParameters];
        int counter = 0;
        for (UnaryFactor uf : this.unaryFactors) {
            if (this.golden.get(uf.getI()) == 0) {
                int n = counter;
                gradient[n] = gradient[n] + 1.0;
            }
            int n = counter++;
            gradient[n] = gradient[n] - this.variables.get((int)uf.getI()).getBelief().measure[0];
            if (this.golden.get(uf.getI()) == 1) {
                int n2 = counter;
                gradient[n2] = gradient[n2] + 1.0;
            }
            int n3 = counter++;
            gradient[n3] = gradient[n3] - this.variables.get((int)uf.getI()).getBelief().measure[1];
        }
        for (BinaryFactor bf : this.binaryFactors) {
            if (this.golden.get(bf.getI()) == 0 && this.golden.get(bf.getJ()) == 0) {
                int n = counter;
                gradient[n] = gradient[n] + 1.0;
            }
            int n = counter++;
            gradient[n] = gradient[n] - this.variables.get((int)bf.getI()).getBelief().measure[0] * this.variables.get((int)bf.getJ()).getBelief().measure[0];
            if (this.golden.get(bf.getI()) == 0 && this.golden.get(bf.getJ()) == 1) {
                int n4 = counter;
                gradient[n4] = gradient[n4] + 1.0;
            }
            int n5 = counter++;
            gradient[n5] = gradient[n5] - this.variables.get((int)bf.getI()).getBelief().measure[0] * this.variables.get((int)bf.getJ()).getBelief().measure[1];
            if (this.golden.get(bf.getI()) == 1 && this.golden.get(bf.getJ()) == 0) {
                int n6 = counter;
                gradient[n6] = gradient[n6] + 1.0;
            }
            int n7 = counter++;
            gradient[n7] = gradient[n7] - this.variables.get((int)bf.getI()).getBelief().measure[1] * this.variables.get((int)bf.getJ()).getBelief().measure[0];
            if (this.golden.get(bf.getI()) == 1 && this.golden.get(bf.getJ()) == 1) {
                int n8 = counter;
                gradient[n8] = gradient[n8] + 1.0;
            }
            int n9 = counter++;
            gradient[n9] = gradient[n9] - this.variables.get((int)bf.getI()).getBelief().measure[1] * this.variables.get((int)bf.getJ()).getBelief().measure[1];
        }
        return gradient;
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public List<UnaryFactor> getUnaryFactor() {
        return this.unaryFactors;
    }
}

