/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.tree.iter.EmptyIterator;

public class ChooseCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Choose choose = (Choose)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ChooseCompiler.visitAnnotation(compiler, "ChooseCompiler-Itr");
        LabelInfo end = methodInfo.newLabel("endChoose");
        boolean needOtherwise = true;
        for (int i = 0; i < choose.size(); ++i) {
            Expression condition = choose.getCondition(i);
            LabelInfo notTrue = null;
            if (i == choose.size() - 1 && Literal.hasEffectiveBooleanValue(condition, true)) {
                needOtherwise = false;
            } else {
                notTrue = methodInfo.newLabel("notTrue" + i);
                compiler.compileToBoolean(condition);
                ga.ifZCmp(153, notTrue.label());
            }
            ChooseCompiler.visitAnnotation(compiler, "when " + condition.toString());
            compiler.compileToIterator(choose.getAction(i));
            ga.goTo(end);
            if (notTrue == null) continue;
            methodInfo.placeLabel(notTrue);
            ga.visitLineNumber(condition.getLocation().getLineNumber(), notTrue.label());
            ChooseCompiler.visitAnnotation(compiler, "when not " + condition.toString());
        }
        if (needOtherwise) {
            ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
        }
        methodInfo.placeLabel(end);
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Choose choose = (Choose)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ChooseCompiler.visitAnnotation(compiler, "ChooseCompiler-Item");
        LabelInfo end = methodInfo.newLabel("endChoose");
        boolean needOtherwise = true;
        for (int i = 0; i < choose.size(); ++i) {
            Expression condition = choose.getCondition(i);
            LabelInfo notTrue = null;
            if (i == choose.size() - 1 && Literal.hasEffectiveBooleanValue(condition, true)) {
                needOtherwise = false;
            } else {
                notTrue = methodInfo.newLabel("notTrue" + i);
                compiler.compileToBoolean(condition);
                ga.ifFalse(notTrue);
            }
            compiler.compileToItem(choose.getAction(i));
            if (i != choose.size() - 1 || needOtherwise) {
                ga.goTo(end);
            }
            if (notTrue == null) continue;
            methodInfo.placeLabel(notTrue);
        }
        if (needOtherwise) {
            ga.pushNull();
        }
        methodInfo.placeLabel(end);
    }

    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        Choose choose = (Choose)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ChooseCompiler.visitAnnotation(compiler, "ChooseCompiler-Boolean");
        LabelInfo end = methodInfo.newLabel("endChoose");
        boolean needOtherwise = true;
        for (int i = 0; i < choose.size(); ++i) {
            Expression condition = choose.getCondition(i);
            LabelInfo notTrue = null;
            if (i == choose.size() - 1 && Literal.hasEffectiveBooleanValue(condition, true)) {
                needOtherwise = false;
            } else {
                notTrue = methodInfo.newLabel("notTrue" + i);
                compiler.compileToBoolean(condition);
                ga.ifZCmp(153, notTrue.label());
            }
            compiler.compileToBoolean(choose.getAction(i));
            ga.goTo(end);
            if (notTrue == null) continue;
            methodInfo.placeLabel(notTrue);
        }
        if (needOtherwise) {
            ga.push(false);
        }
        methodInfo.placeLabel(end);
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        Choose choose = (Choose)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ChooseCompiler.visitAnnotation(compiler, "ChooseCompiler-Boolean");
        LabelInfo end = methodInfo.newLabel("endChoose");
        boolean needOtherwise = true;
        for (int i = 0; i < choose.size(); ++i) {
            Expression condition = choose.getCondition(i);
            LabelInfo notTrue = null;
            if (i == choose.size() - 1 && Literal.hasEffectiveBooleanValue(condition, true)) {
                needOtherwise = false;
            } else {
                notTrue = methodInfo.newLabel("notTrue" + i);
                compiler.compileToBoolean(condition);
                ga.ifZCmp(153, notTrue.label());
            }
            compiler.compileToPrimitive(choose.getAction(i), requiredClass, onEmpty);
            ga.goTo(end);
            if (notTrue == null) continue;
            methodInfo.placeLabel(notTrue);
        }
        if (needOtherwise) {
            onEmpty.generate(ga);
        }
        methodInfo.placeLabel(end);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Choose choose = (Choose)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ChooseCompiler.visitAnnotation(compiler, "ChooseCompiler-Push");
        LabelInfo end = methodInfo.newLabel("endChoose");
        for (int i = 0; i < choose.size(); ++i) {
            Expression condition = choose.getCondition(i);
            LabelInfo notTrue = null;
            if (i != choose.size() - 1 || !Literal.hasEffectiveBooleanValue(condition, true)) {
                notTrue = methodInfo.newLabel("notTrue" + i);
                compiler.compileToBoolean(condition);
                ga.ifZCmp(153, notTrue.label());
            }
            compiler.compileToPush(choose.getAction(i));
            ga.goTo(end);
            if (notTrue == null) continue;
            methodInfo.placeLabel(notTrue);
        }
        methodInfo.placeLabel(end);
    }
}

