/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma;

import java.util.List;
import lemming.lemma.toutanova.EditTreeAligner;
import marmot.util.FeatUtil;
import marmot.util.SymbolTable;
import marmot.util.edit.EditTree;
import marmot.util.edit.EditTreeBuilder;

public class LemmaCandidate {
    private double score_;
    private int[] feature_indexes_;
    private short[] lemma_chars_;
    private List<Integer> alignment_;
    private Integer tree_index_;

    public void setScore(double score) {
        this.score_ = score;
    }

    public double getScore() {
        return this.score_;
    }

    public int[] getFeatureIndexes() {
        return this.feature_indexes_;
    }

    public void setFeatureIndexes(int[] feature_indexes) {
        this.feature_indexes_ = feature_indexes;
    }

    public short[] getLemmaChars(SymbolTable<Character> char_table, String lemma, boolean insert) {
        if (this.lemma_chars_ == null) {
            this.lemma_chars_ = FeatUtil.getCharIndexes(lemma, char_table, insert);
        }
        return this.lemma_chars_;
    }

    public List<Integer> getAlignment(EditTreeAligner aligner, String form, String lemma) {
        if (this.alignment_ == null) {
            this.alignment_ = aligner.align(form, lemma);
        }
        return this.alignment_;
    }

    public Integer getTreeIndex(EditTreeBuilder builder, String form, String lemma, SymbolTable<EditTree> tree_table, boolean insert) {
        if (this.tree_index_ == null) {
            EditTree tree = builder.build(form, lemma);
            this.tree_index_ = tree_table.toIndex(tree, -1, insert);
        }
        return this.tree_index_;
    }
}

