/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.util;

import com.saxonica.ee.bytecode.util.ByteCodeTrace;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.NamedLabel;
import com.saxonica.objectweb.asm.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class GeneratedMethodInfo {
    public Generator currentGenerator;
    public boolean debug;
    private LabelInfo tailCallLabel = null;
    private Stack<ContextVariableInfo> contextVariableStack = new Stack();
    private Stack<SequenceReceiverInfo> sequenceReceiverStack = new Stack();
    public Set<LabelInfo> labelMap = new HashSet<LabelInfo>();
    public List<LocalSlotInfo> slotList = new ArrayList<LocalSlotInfo>(20);
    private Stack<LabelInfo> xslIterateLoopLabelStack = new Stack();
    private Stack<LabelInfo> xslIterateBreakLabelStack = new Stack();

    public void pushContextVariableInfo(int position, boolean isArgument) {
        ContextVariableInfo info = new ContextVariableInfo();
        info.contextVariablePosition = position;
        info.contextIsArgument = isArgument;
        this.contextVariableStack.push(info);
    }

    public void pushSequenceReceiverInfo(int position) {
        SequenceReceiverInfo info = new SequenceReceiverInfo();
        info.receiverPosition = position;
        this.sequenceReceiverStack.push(info);
    }

    public void popContextVariableInfo() {
        this.contextVariableStack.pop();
    }

    public void popSequenceReceiverInfo() {
        this.sequenceReceiverStack.pop();
    }

    public int getContextVariablePosition() {
        return this.contextVariableStack.peek().contextVariablePosition;
    }

    public int getSequenceReceiverPosition() {
        return this.sequenceReceiverStack.peek().receiverPosition;
    }

    public boolean isSequenceReceiverInitialized() {
        return ((SequenceReceiverInfo)this.sequenceReceiverStack.get((int)0)).receiverPosition != -1;
    }

    public boolean isContextVariableAnArgument() {
        return this.contextVariableStack.peek().contextIsArgument;
    }

    public Generator getCurrentGenerator() {
        return this.currentGenerator;
    }

    public LabelInfo newLabel(String name) {
        LabelInfo labelInfo = new LabelInfo();
        labelInfo.name = name;
        labelInfo.theLabel = new NamedLabel();
        labelInfo.theLabel.setName(name);
        this.labelMap.add(labelInfo);
        return labelInfo;
    }

    public void placeLabel(LabelInfo labelInfo) {
        if (labelInfo.isMarked) {
            throw new AssertionError((Object)("The Label: " + labelInfo.name + " has already been marked"));
        }
        labelInfo.isMarked = true;
        this.currentGenerator.mark(labelInfo.theLabel);
        this.generateTracePoint(labelInfo.name);
    }

    public LabelInfo placeNewLabel(String name) {
        LabelInfo label = this.newLabel(name);
        this.placeLabel(label);
        return label;
    }

    public void checkLabels() {
        for (LabelInfo labelInfo : this.labelMap) {
            if (labelInfo.isUsed() && !labelInfo.isMarked) {
                throw new AssertionError((Object)("The Label: " + labelInfo.name + " has been used but not marked"));
            }
        }
    }

    public Stack<LabelInfo> getXslIterateLoopLabelStack() {
        return this.xslIterateLoopLabelStack;
    }

    public Stack<LabelInfo> getXslIterateBreakLabelStack() {
        return this.xslIterateBreakLabelStack;
    }

    public int allocateLocal(Class theClass) {
        LocalSlotInfo slot2;
        for (LocalSlotInfo slot2 : this.slotList) {
            if (slot2.theClass != theClass || slot2.inUse) continue;
            slot2.inUse = true;
            return slot2.slotNumber;
        }
        int t = this.currentGenerator.newLocal(Type.getType(theClass));
        slot2 = new LocalSlotInfo();
        slot2.theClass = theClass;
        slot2.inUse = true;
        slot2.slotNumber = t;
        this.slotList.add(slot2);
        return t;
    }

    public void releaseLocal(int slotNumber) {
        for (LocalSlotInfo slot : this.slotList) {
            if (slot.slotNumber != slotNumber) continue;
            slot.inUse = false;
            return;
        }
    }

    private void generateTracePoint(String labelName) {
        if (this.debug) {
            this.currentGenerator.push(CompilerService.tracePoint++);
            this.currentGenerator.invokeStaticMethod(ByteCodeTrace.class, "trace", Integer.TYPE);
        }
    }

    public void setTailCallLabel(LabelInfo label) {
        this.tailCallLabel = label;
    }

    public LabelInfo getTailCallLabel() {
        return this.tailCallLabel;
    }

    public static class LocalSlotInfo {
        public int slotNumber;
        public Class theClass;
        public boolean inUse;
    }

    private static class SequenceReceiverInfo {
        public int receiverPosition;

        private SequenceReceiverInfo() {
        }
    }

    private static class ContextVariableInfo {
        public int contextVariablePosition;
        public boolean contextIsArgument;

        private ContextVariableInfo() {
        }
    }
}

