/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.AnyType;

public class ShallowCopyEventFeed
extends ItemFeed {
    Mode mode;

    public ShallowCopyEventFeed(Mode mode, Feed parentExpressionFeed, XPathContext context) {
        super(null, parentExpressionFeed, context);
        this.mode = mode;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        XPathContext context = this.getContext();
        Receiver receiver = this.getResult().getReceiver();
        NodeInfo node = (NodeInfo)context.getContextItem();
        if (node.getNodeKind() == 9) {
            receiver.startDocument(0);
        } else {
            receiver.startElement(NameOfNode.makeName(node), AnyType.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            NamespaceIterator.sendNamespaces(node, receiver);
            AxisIterator attributes = node.iterateAxis((byte)2);
            if (attributes != EmptyIterator.OfNodes.THE_INSTANCE) {
                XPathContextMajor c2 = context.newContext();
                c2.setReceiver(this.getResult().getReceiver());
                c2.trackFocus(node.iterateAxis((byte)2));
                this.mode.applyTemplates(context.getLocalParameters(), context.getTunnelParameters(), c2, ExplicitLocation.UNKNOWN_LOCATION);
            }
        }
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        this.getResult().getReceiver().append(item);
    }

    @Override
    public void close() throws XPathException {
        XPathContext context = this.getContext();
        Receiver receiver = this.getResult().getReceiver();
        NodeInfo node = (NodeInfo)context.getContextItem();
        if (node.getNodeKind() == 9) {
            receiver.endDocument();
        } else {
            receiver.endElement();
        }
        super.close();
    }
}

