/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.ranker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import lemming.lemma.LemmaCandidate;
import lemming.lemma.LemmaCandidateSet;
import lemming.lemma.LemmaInstance;
import lemming.lemma.ranker.RankerInstance;
import lemming.lemma.ranker.RankerTrainer;
import lemming.lemma.toutanova.EditTreeAligner;
import marmot.morph.HashDictionary;
import marmot.morph.MorphDictionaryOptions;
import marmot.util.AspellLexicon;
import marmot.util.Converter;
import marmot.util.Encoder;
import marmot.util.FeatureTable;
import marmot.util.HashLexicon;
import marmot.util.Lexicon;
import marmot.util.StringUtils;
import marmot.util.SymbolTable;
import marmot.util.edit.EditTree;

public class RankerModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[] weights_;
    private SymbolTable<String> form_table_;
    private SymbolTable<String> lemma_table_;
    private SymbolTable<String> pos_table_;
    private SymbolTable<Character> char_table_;
    private SymbolTable<EditTree> tree_table_;
    private EditTreeAligner aligner_;
    private static final int max_window = 5;
    private static final int window_bits_ = Encoder.bitsNeeded(5);
    private static final int max_affix_length_ = 10;
    private static final int feature_bits_ = Encoder.bitsNeeded(Features.values().length - 1);
    private static final int unigram_count_position_bits_ = Encoder.bitsNeeded(HashLexicon.ARRAY_LENGTH - 1);
    private static final long max_weights_length_ = 11549873L;
    private static final int encoder_capacity_ = 15;
    private Set<Integer> ignores_indexes_;
    private int cluster_bits_;
    private int lemma_bits_;
    private int form_bits_;
    private int char_bits_;
    private int tree_bits_;
    private List<Lexicon> unigram_lexicons_;
    private int unigram_lexicons_bits_;
    private SymbolTable<String> morph_table_;
    private FeatureTable feature_table_;
    private transient Encoder encoder_;
    private transient Context context_;
    private int real_capacity_;
    private long pos_length_;
    private long feat_length_;
    private boolean use_shape_lexicon_;
    private boolean use_core_features_;
    private boolean use_alignment_features_;
    private transient double[] accumulated_penalties_;
    private double accumulated_penalty_;
    private boolean copy_conjunctions_;
    private HashDictionary cluster_dict_;
    private static final double EPSILON = 1.0E-10;
    private static final int length_bits_ = Encoder.bitsNeeded(20);

    public void init(RankerTrainer.RankerTrainerOptions options, List<RankerInstance> instances, EditTreeAligner aligner) {
        SymbolTable<String> pos_table = null;
        if (options.getUsePos()) {
            pos_table = new SymbolTable<String>();
        }
        SymbolTable<String> morph_table = null;
        if (options.getUseMorph()) {
            morph_table = new SymbolTable<String>();
        }
        this.init(options, instances, aligner, pos_table, morph_table);
    }

    public void init(RankerTrainer.RankerTrainerOptions options, List<RankerInstance> instances, EditTreeAligner aligner, SymbolTable<String> pos_table, SymbolTable<String> morph_table) {
        String string;
        Logger logger = Logger.getLogger(this.getClass().getName());
        this.aligner_ = aligner;
        this.form_table_ = new SymbolTable();
        this.lemma_table_ = new SymbolTable();
        this.char_table_ = new SymbolTable();
        this.tree_table_ = new SymbolTable();
        this.pos_table_ = pos_table;
        this.morph_table_ = morph_table;
        for (RankerInstance rankerInstance : instances) {
            this.fillTables(rankerInstance, rankerInstance.getCandidateSet());
        }
        this.form_bits_ = Encoder.bitsNeeded(this.form_table_.size() - 1);
        this.lemma_bits_ = Encoder.bitsNeeded(this.lemma_table_.size() - 1);
        this.char_bits_ = Encoder.bitsNeeded(this.char_table_.size());
        this.tree_bits_ = Encoder.bitsNeeded(this.tree_table_.size() - 1);
        logger.info(String.format("Number of edit trees: %5d", this.tree_table_.size()));
        if (this.pos_table_ != null) {
            logger.info(String.format("Number of POS features: %3d", this.pos_table_.size()));
            logger.info(String.format("POS features: %s", this.pos_table_.keySet()));
        }
        if (this.morph_table_ != null) {
            logger.info(String.format("Number of morph features: %3d", this.morph_table_.size()));
            logger.info(String.format("Morph features: %s", this.morph_table_.keySet()));
        }
        int num_candidates = 0;
        for (RankerInstance rankerInstance : instances) {
            num_candidates += rankerInstance.getCandidateSet().size();
        }
        logger.info(String.format("Candidates per token: %d / %d = %g", num_candidates, instances.size(), (double)num_candidates / (double)instances.size()));
        List<Object> list = options.getUnigramFile();
        this.unigram_lexicons_ = new LinkedList<Lexicon>();
        for (Object object : list) {
            this.prepareUnigramFeature((String)object);
        }
        String string2 = options.getClusterFile();
        this.cluster_dict_ = null;
        if (!string2.isEmpty()) {
            this.prepareClusterFeature(string2);
        }
        if (!(string = options.getAspellPath()).isEmpty()) {
            String aspell_lang = options.getAspellLang();
            logger.info(String.format("Adding aspell dictionary: %s", aspell_lang));
            this.unigram_lexicons_.add(new AspellLexicon(StringUtils.Mode.lower, string, aspell_lang));
        }
        this.unigram_lexicons_bits_ = Encoder.bitsNeeded(this.unigram_lexicons_.size());
        if (this.cluster_dict_ != null) {
            this.cluster_bits_ = Encoder.bitsNeeded(this.cluster_dict_.numTags());
        }
        this.use_shape_lexicon_ = options.getUseShapeLexicon();
        this.use_core_features_ = options.getUseCoreFeatures();
        this.use_alignment_features_ = options.getUseAlignmentFeatures();
        this.copy_conjunctions_ = options.getCopyConjunctions();
        boolean use_hash_feature_table = options.getUseHashFeatureTable();
        this.feature_table_ = FeatureTable.StaticMethods.create(use_hash_feature_table);
        logger.info("Starting feature index extraction.");
        if (options.getUseOfflineFeatureExtraction()) {
            for (RankerInstance instance : instances) {
                this.addIndexes(instance, instance.getCandidateSet(), true);
            }
        }
        this.feat_length_ = 1254997L;
        if (this.feature_table_ != null && options.getUseOfflineFeatureExtraction()) {
            this.feat_length_ = this.feature_table_.size();
        }
        this.pos_length_ = this.pos_table_ == null ? 1L : (long)(this.pos_table_.size() + 1);
        long morph_length = this.morph_table_ == null ? 1L : (long)(this.morph_table_.size() + 1);
        long actual_length = this.feat_length_ * this.pos_length_ * morph_length;
        logger.info(String.format("Actual weights length: %12d", actual_length));
        int length = (int)Math.min(actual_length, 11549873L);
        this.weights_ = new double[length];
        if (this.feature_table_ != null && options.getUseOfflineFeatureExtraction()) {
            logger.info(String.format("Number of features: %10d", this.feature_table_.size()));
        }
        logger.info(String.format("Weights length: %6d", this.weights_.length));
        logger.info(String.format("Real encoder capacity: %2d", this.real_capacity_));
        String ignore_string = options.getIgnoreFeatures();
        if (!ignore_string.isEmpty() && this.morph_table_ != null) {
            this.ignores_indexes_ = new HashSet<Integer>();
            logger.info(String.format("Ignore-string: %s (%s)", ignore_string, this.morph_table_));
            for (String feat : ignore_string.split("\\|")) {
                int index = this.morph_table_.toIndex(feat, -1);
                this.ignores_indexes_.add(index);
                logger.info(String.format("Ignore-string: %s (%d)", feat, index));
            }
        }
    }

    private void prepareClusterFeature(String cluster_file) {
        MorphDictionaryOptions options = MorphDictionaryOptions.parse(cluster_file + ",indexes=[1],norm=umlaut");
        this.cluster_dict_ = new HashDictionary();
        this.cluster_dict_.init(options);
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.info(String.format("Creating cluster lexicon from file: %s with %d entries and %d tags", cluster_file, this.cluster_dict_.size(), this.cluster_dict_.numTags()));
    }

    private void prepareUnigramFeature(String unigram_file) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (unigram_file.isEmpty()) {
            return;
        }
        String filename = null;
        int min_count = 0;
        for (String argument : unigram_file.split(",")) {
            int index = argument.indexOf(61);
            if (index >= 0) {
                String argname = argument.substring(0, index);
                String value = argument.substring(index + 1);
                if (argname.equalsIgnoreCase("min-count")) {
                    min_count = Integer.parseInt(value);
                    continue;
                }
                throw new RuntimeException(String.format("Unknown option: %s", argname));
            }
            filename = argument;
        }
        if (filename == null) {
            throw new RuntimeException(String.format("No filename specified: %s", unigram_file));
        }
        logger.info(String.format("Creating unigram lexicon from file: %s and with min-count %d.", filename, min_count));
        HashLexicon lexicon = HashLexicon.readFromFile(filename, min_count);
        logger.info(String.format("Created unigram lexicon with %7d entries.", lexicon.size()));
        this.unigram_lexicons_.add(lexicon);
    }

    private void fillTables(RankerInstance instance, LemmaCandidateSet set) {
        String form = instance.getInstance().getForm();
        this.form_table_.insert(form);
        instance.getFormChars(this.char_table_, true);
        instance.getPosIndex(this.pos_table_, true);
        instance.getMorphIndexes(this.morph_table_, true);
        for (Map.Entry<String, LemmaCandidate> candidate_pair : set) {
            String lemma = candidate_pair.getKey();
            LemmaCandidate candidate = candidate_pair.getValue();
            if (this.use_alignment_features_) {
                candidate.getLemmaChars(this.char_table_, lemma, true);
                candidate.getAlignment(this.aligner_, form, lemma);
            }
            candidate.getTreeIndex(this.aligner_.getBuilder(), form, lemma, this.tree_table_, true);
            this.lemma_table_.insert(lemma);
        }
    }

    public void removeIndexes(LemmaCandidateSet set) {
        for (Map.Entry<String, LemmaCandidate> candidate_pair : set) {
            LemmaCandidate candidate = candidate_pair.getValue();
            candidate.setFeatureIndexes(null);
        }
    }

    public void addIndexes(RankerInstance instance, LemmaCandidateSet set, boolean insert) {
        int[] form_cluster_indexes = null;
        if (this.cluster_dict_ != null) {
            form_cluster_indexes = this.cluster_dict_.getIndexes(instance.getInstance().getForm());
        }
        if (this.context_ == null) {
            this.context_ = new Context();
            this.encoder_ = new Encoder(15);
        }
        String form = instance.getInstance().getForm();
        int form_index = this.form_table_.toIndex(form, -1);
        this.context_.insert = insert;
        short[] form_chars = instance.getFormChars(this.char_table_, false);
        for (Map.Entry<String, LemmaCandidate> candidate_pair : set) {
            if (candidate_pair.getValue().getFeatureIndexes() != null) continue;
            this.context_.list.clear();
            String lemma = candidate_pair.getKey();
            int[] lemma_cluster_indexes = null;
            if (this.cluster_dict_ != null) {
                lemma_cluster_indexes = this.cluster_dict_.getIndexes(lemma);
            }
            if (lemma_cluster_indexes != null) {
                for (int lemma_cluster_index : lemma_cluster_indexes) {
                    this.encoder_.append(Features.lemma_cluster_feature.ordinal(), feature_bits_);
                    this.encoder_.append(lemma_cluster_index, this.cluster_bits_);
                    this.addFeature();
                }
                if (form_cluster_indexes != null) {
                    for (int form_cluster_index : form_cluster_indexes) {
                        int[] nArray = lemma_cluster_indexes;
                        int n = nArray.length;
                        for (int i = 0; i < n; ++i) {
                            int lemma_cluster_index = nArray[i];
                            this.encoder_.append(Features.form_cluster_lemma_cluster_feature.ordinal(), feature_bits_);
                            this.encoder_.append(lemma_cluster_index, this.cluster_bits_);
                            this.encoder_.append(form_cluster_index, this.cluster_bits_);
                            this.addFeature();
                        }
                    }
                }
            }
            int lemma_index = this.lemma_table_.toIndex(lemma, -1, false);
            LemmaCandidate candidate = candidate_pair.getValue();
            if (this.use_core_features_) {
                int tree_index;
                if (lemma_index >= 0) {
                    this.encoder_.append(Features.lemma_feature.ordinal(), feature_bits_);
                    this.encoder_.append(lemma_index, this.lemma_bits_);
                    this.addFeature();
                }
                if (lemma_index >= 0 && form_index >= 0) {
                    this.encoder_.append(Features.lemma_form_feature.ordinal(), feature_bits_);
                    this.encoder_.append(lemma_index, this.lemma_bits_);
                    this.encoder_.append(form_index, this.form_bits_);
                    this.addFeature();
                }
                if ((tree_index = candidate.getTreeIndex(this.aligner_.getBuilder(), form, lemma, this.tree_table_, false).intValue()) >= 0) {
                    this.encoder_.append(Features.tree_feature.ordinal(), feature_bits_);
                    this.encoder_.append(tree_index, this.tree_bits_);
                    this.addFeature();
                    this.encoder_.append(Features.tree_feature.ordinal(), feature_bits_);
                    this.encoder_.append(tree_index, this.tree_bits_);
                    this.addPrefixFeatures(form_chars);
                    this.encoder_.reset();
                    this.encoder_.append(Features.tree_feature.ordinal(), feature_bits_);
                    this.encoder_.append(tree_index, this.tree_bits_);
                    this.addSuffixFeatures(form_chars);
                    this.encoder_.reset();
                    if (form_cluster_indexes != null) {
                        for (int cluster_index : form_cluster_indexes) {
                            this.encoder_.append(Features.tree_form_cluster_feature.ordinal(), feature_bits_);
                            this.encoder_.append(tree_index, this.tree_bits_);
                            this.encoder_.append(cluster_index, this.cluster_bits_);
                            this.addFeature();
                        }
                    }
                }
            }
            if (this.use_alignment_features_) {
                short[] lemma_chars = candidate.getLemmaChars(this.char_table_, lemma, false);
                List<Integer> alignment = candidate.getAlignment(this.aligner_, form, lemma);
                this.addAlignmentIndexes(form_chars, lemma_chars, alignment);
                this.addAffixIndexes(lemma_chars);
            }
            int lexicon_index = 0;
            for (Lexicon lexicon : this.unigram_lexicons_) {
                this.addUnigramFeature(lexicon_index, lexicon, lemma);
                ++lemma_index;
            }
            candidate.setFeatureIndexes(Converter.toIntArray(this.context_.list));
        }
    }

    private void addUnigramFeature(int lexicon_index, Lexicon unigram_lexicon, String lemma) {
        int[] counts = unigram_lexicon.getCount(lemma);
        if (counts == null) {
            return;
        }
        if (this.use_shape_lexicon_) {
            for (int i = 0; i < HashLexicon.ARRAY_LENGTH; ++i) {
                int count2 = counts[i];
                if (count2 <= 0) continue;
                this.encoder_.append(Features.lexicon_feature.ordinal(), feature_bits_);
                this.encoder_.append(lexicon_index, this.unigram_lexicons_bits_);
                this.encoder_.append(i, unigram_count_position_bits_);
                this.addFeature();
            }
        } else {
            int count3 = counts[HashLexicon.ARRAY_LENGTH - 1];
            if (count3 > 0) {
                this.encoder_.append(Features.lexicon_feature.ordinal(), feature_bits_);
                this.encoder_.append(lexicon_index, this.unigram_lexicons_bits_);
                this.addFeature();
            }
        }
    }

    private void addPrefixFeatures(short[] chars) {
        this.encoder_.append(false);
        for (int i = 0; i < Math.min(chars.length, 10); ++i) {
            short c = chars[i];
            if (c < 0) {
                return;
            }
            this.encoder_.append(c, this.char_bits_);
            this.addFeature(false);
        }
    }

    private void addSuffixFeatures(short[] chars) {
        this.encoder_.append(true);
        for (int i = chars.length - 1; i >= Math.max(0, chars.length - 10); --i) {
            short c = chars[i];
            if (c < 0) {
                return;
            }
            this.encoder_.append(c, this.char_bits_);
            this.addFeature(false);
        }
    }

    private void addAffixIndexes(short[] lemma_chars) {
        this.encoder_.append(Features.affix_feature.ordinal(), feature_bits_);
        this.addPrefixFeatures(lemma_chars);
        this.encoder_.reset();
        this.encoder_.append(Features.affix_feature.ordinal(), feature_bits_);
        this.addSuffixFeatures(lemma_chars);
        this.encoder_.reset();
    }

    private void addAlignmentIndexes(short[] form_chars, short[] lemma_chars, List<Integer> alignment) {
        Iterator<Integer> iterator2 = alignment.iterator();
        int input_start = 0;
        int output_start = 0;
        while (iterator2.hasNext()) {
            int input_length = iterator2.next();
            int output_length = iterator2.next();
            int input_end = input_start + input_length;
            int output_end = output_start + output_length;
            this.addAlignmentSegmentIndexes(form_chars, lemma_chars, input_start, input_end, output_start, output_end);
            input_start = input_end;
            output_start = output_end;
        }
    }

    private void addAlignmentSegmentIndexes(short[] form_chars, short[] lemma_chars, int input_start, int input_end, int output_start, int output_end) {
        if (this.isCopySegment(form_chars, lemma_chars, input_start, input_end, output_start, output_end)) {
            this.encoder_.append(Features.align_copy_feature.ordinal(), feature_bits_);
            this.addFeature();
            if (!this.copy_conjunctions_) {
                return;
            }
        }
        this.encoder_.append(Features.align_feature.ordinal(), feature_bits_);
        this.addSegment(form_chars, input_start, input_end);
        this.addSegment(lemma_chars, output_start, output_end);
        this.addFeature(false);
        this.addWindow(form_chars, lemma_chars, input_start, input_end, output_start, output_end);
        this.encoder_.reset();
        this.encoder_.append(Features.align_feature_output.ordinal(), feature_bits_);
        this.addSegment(lemma_chars, output_start, output_end);
        this.addFeature(false);
        this.addWindow(form_chars, lemma_chars, input_start, input_end, output_start, output_end);
        this.encoder_.reset();
    }

    private void addWindow(short[] form_chars, short[] lemma_chars, int input_start, int input_end, int output_start, int output_end) {
        this.encoder_.storeState();
        int feature_bits_ = 3;
        for (int window = 1; window <= 5; ++window) {
            int index = 0;
            this.encoder_.append(index++, feature_bits_);
            this.encoder_.append(window, window_bits_);
            this.addSegment(form_chars, input_start - window, input_start);
            this.addSegment(form_chars, input_end + 1, input_end + window + 1);
            this.addFeature(false);
            this.encoder_.restoreState();
            this.encoder_.append(index++, feature_bits_);
            this.encoder_.append(window, window_bits_);
            this.addSegment(form_chars, input_end + 1, input_end + window + 1);
            this.addFeature(false);
            this.encoder_.restoreState();
            this.encoder_.append(index++, feature_bits_);
            this.encoder_.append(window, window_bits_);
            this.addSegment(form_chars, input_start - window, input_start);
            this.addFeature(false);
            this.encoder_.restoreState();
        }
    }

    private boolean isCopySegment(short[] form_chars, short[] lemma_chars, int input_start, int input_end, int output_start, int output_end) {
        if (input_end - input_start != 1) {
            return false;
        }
        if (output_end - output_start != 1) {
            return false;
        }
        return form_chars[input_start] == lemma_chars[output_start];
    }

    private void addSegment(short[] chars, int start, int end) {
        this.encoder_.append(end - start, length_bits_);
        for (int i = start; i < end; ++i) {
            int c = i >= 0 && i < chars.length ? chars[i] : this.char_table_.size();
            if (c < 0) {
                return;
            }
            this.encoder_.append(c, this.char_bits_);
        }
    }

    private void addFeature(boolean reset) {
        this.real_capacity_ = Math.max(this.real_capacity_, this.encoder_.getCurrentLength());
        int index = this.feature_table_.getFeatureIndex(this.encoder_, this.context_.insert);
        if (index >= 0) {
            this.context_.list.add(index);
        }
        if (reset) {
            this.encoder_.reset();
        }
    }

    private void addFeature() {
        this.addFeature(true);
    }

    public String select(RankerInstance instance) {
        Map.Entry<String, LemmaCandidate> best_pair = null;
        for (Map.Entry<String, LemmaCandidate> candidate_pair : instance.getCandidateSet()) {
            LemmaCandidate candidate = candidate_pair.getValue();
            double score = this.score(candidate, instance.getPosIndex(this.pos_table_, false), instance.getMorphIndexes(this.morph_table_, false));
            candidate.setScore(score);
            if (best_pair != null && !(score > best_pair.getValue().getScore())) continue;
            best_pair = candidate_pair;
        }
        return (String)best_pair.getKey();
    }

    public double score(LemmaCandidate candidate, int pos_index, int[] morph_indexes) {
        assert (candidate != null);
        double score = 0.0;
        for (int index : candidate.getFeatureIndexes()) {
            score += this.updateScore(index, pos_index, morph_indexes, 0.0);
        }
        return score;
    }

    public void update(RankerInstance instance, String lemma, double update) {
        LemmaCandidate candidate = instance.getCandidateSet().getCandidate(lemma);
        this.update(candidate, instance.getPosIndex(this.pos_table_, false), instance.getMorphIndexes(this.morph_table_, false), update);
    }

    public void update(LemmaCandidate candidate, int pos_index, int[] morph_indexes, double update) {
        for (int index : candidate.getFeatureIndexes()) {
            this.updateScore(index, pos_index, morph_indexes, update);
        }
    }

    private double updateScore(long index, long pos_index, int[] morph_indexes, double update) {
        double score = 0.0;
        long f_index = index;
        score += this.updateScore(f_index, update);
        if (pos_index >= 0L) {
            long p_index = f_index + this.feat_length_ * (pos_index + 1L);
            score += this.updateScore(p_index, update);
            int[] nArray = morph_indexes;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                long morph_index = nArray[i];
                if (this.ignores_indexes_ != null && this.ignores_indexes_.contains((int)morph_index)) continue;
                long m_index = p_index + (morph_index + 1L) * this.feat_length_ * this.pos_length_;
                score += this.updateScore(m_index, update);
            }
        }
        return score;
    }

    private double updateScore(long index, double update) {
        int int_index;
        int n = int_index = (int)(index % (long)this.weights_.length);
        this.weights_[n] = this.weights_[n] + update;
        if (this.accumulated_penalties_ != null && Math.abs(update) > 1.0E-10) {
            this.applyPenalty(this.weights_[int_index], int_index);
        }
        return this.weights_[int_index];
    }

    public void setPenalty(boolean penalize, double accumulated_penalty) {
        if (penalize) {
            this.accumulated_penalty_ = accumulated_penalty;
            if (this.accumulated_penalties_ == null) {
                this.accumulated_penalties_ = new double[this.weights_.length];
            }
        } else {
            this.accumulated_penalties_ = null;
        }
    }

    private void applyPenalty(double weight, int index) {
        double old_weight = weight;
        if (old_weight - 1.0E-10 > 0.0) {
            weight = Math.max(0.0, old_weight - (this.accumulated_penalty_ + this.accumulated_penalties_[index]));
        } else if (old_weight + 1.0E-10 < 0.0) {
            weight = Math.min(0.0, old_weight + (this.accumulated_penalty_ - this.accumulated_penalties_[index]));
        }
        int n = index;
        this.accumulated_penalties_[n] = this.accumulated_penalties_[n] + (weight - old_weight);
        this.weights_[index] = weight;
    }

    public double[] getWeights() {
        return this.weights_;
    }

    public void setWeights(double[] weights) {
        this.weights_ = weights;
    }

    public SymbolTable<String> getPosTable() {
        return this.pos_table_;
    }

    public SymbolTable<String> getMorphTable() {
        return this.morph_table_;
    }

    public boolean isOOV(LemmaInstance instance) {
        return this.form_table_.toIndex(instance.getForm(), -1) == -1;
    }

    public List<Double> scores(RankerInstance rinstance) {
        LemmaCandidateSet set = rinstance.getCandidateSet();
        ArrayList<Double> scores = new ArrayList<Double>(set.size());
        for (LemmaCandidate candidate : set.getCandidates()) {
            double score = this.score(candidate, rinstance.getPosIndex(this.pos_table_, false), rinstance.getMorphIndexes(this.morph_table_, false));
            scores.add(score);
            candidate.setScore(score);
        }
        return scores;
    }

    private static class Context {
        public List<Integer> list = new ArrayList<Integer>();
        public boolean insert;
    }

    private static enum Features {
        lemma_feature,
        lemma_form_feature,
        align_feature,
        align_copy_feature,
        tree_feature,
        affix_feature,
        lexicon_feature,
        align_feature_output,
        tree_form_cluster_feature,
        lemma_cluster_feature,
        form_cluster_lemma_cluster_feature;

    }
}

