/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.Characteristic;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.z.IntEmptySet;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSingletonSet;

public class GeneralComparisonOperand
extends Characteristic<IntSet> {
    Expression exp;
    boolean multiValued;
    StringCollator collator;

    public GeneralComparisonOperand(StringCollator collator, Expression exp) {
        this.collator = collator;
        this.exp = exp;
        this.multiValued = Cardinality.allowsMany(exp.getCardinality());
    }

    @Override
    public IntSet evaluate(XPathContext context) throws XPathException {
        if (this.multiValued) {
            SequenceIterator<?> iter = this.exp.iterate(context);
            IntHashSet keys = new IntHashSet();
            iter.forEachOrFail(item -> keys.add(this.collator.getCollationKey(item.getStringValueCS()).hashCode()));
            return keys;
        }
        Item<?> item2 = this.exp.evaluateItem(context);
        if (item2 == null) {
            return IntEmptySet.getInstance();
        }
        return new IntSingletonSet(this.collator.getCollationKey(item2.getStringValueCS()).hashCode());
    }

    public int hashCode() {
        return this.exp.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GeneralComparisonOperand && this.exp.isEqual(((GeneralComparisonOperand)obj).exp) && this.collator.equals(((GeneralComparisonOperand)obj).collator);
    }

    public String toString() {
        return this.exp.toString();
    }
}

