/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.lib.ValidationStatisticsRecipient;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;

public class StatisticsReporter
implements ValidationStatisticsRecipient {
    private XMLStreamWriter writer;

    public StatisticsReporter() {
    }

    public StatisticsReporter(Receiver receiver) {
        this.setReceiver(receiver);
    }

    public void setReceiver(Receiver receiver) {
        this.writer = new StreamWriterToReceiver(receiver);
    }

    @Override
    public void notifyValidationStatistics(Map<SchemaComponent, Integer> statistics) throws XPathException {
        if (this.writer == null) {
            throw new IllegalStateException("No writer has been set");
        }
        try {
            this.writer.writeStartDocument();
            this.writer.writeStartElement("schemaCoverage");
            for (Map.Entry<SchemaComponent, Integer> entry : statistics.entrySet()) {
                SchemaComponent component = entry.getKey();
                int count = entry.getValue();
                String kind = null;
                String namespace = null;
                String localname = null;
                if (component instanceof SchemaType) {
                    kind = ((SchemaType)component).isComplexType() ? "complexType" : "simpleType";
                    namespace = ((SchemaType)component).getTargetNamespace();
                    localname = ((SchemaType)component).getName();
                } else if (component instanceof ElementDecl) {
                    kind = "element";
                    namespace = ((ElementDecl)component).getTargetNamespace();
                    localname = ((ElementDecl)component).getName();
                }
                this.writer.writeEmptyElement("component");
                this.writer.writeAttribute("kind", kind);
                this.writer.writeAttribute("namespace", namespace);
                this.writer.writeAttribute("name", localname);
                this.writer.writeAttribute("count", count + "");
            }
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new XPathException("Failure to write to statistics report file", e);
        }
    }
}

