/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config.pe;

import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.xsltextn.ExtensionElementFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLModuleRoot;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeFactory;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaType;

public class StyleNodeFactoryPE
extends StyleNodeFactory
implements NodeFactory {
    protected boolean allowExtensions;

    public StyleNodeFactoryPE(Configuration config, Compilation compilation) {
        super(config, compilation);
        this.allowExtensions = config.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS);
    }

    @Override
    public ElementImpl makeElementNode(NodeInfo parent, NodeName elementName, SchemaType elementType, boolean isNilled, AttributeCollectionImpl attlist, NamespaceBinding[] namespaces, int namespacesUsed, PipelineConfiguration pipe, Location location, int sequence) {
        StyleElement node;
        StyleElement temp;
        boolean toplevel = parent instanceof XSLModuleRoot;
        if (elementName.hasURI("http://www.w3.org/1999/XSL/Transform") || !this.allowExtensions || parent instanceof DataElement) {
            return super.makeElementNode(parent, elementName, elementType, isNilled, attlist, namespaces, namespacesUsed, pipe, location, sequence);
        }
        Class<? extends StyleElement> extensionClass = null;
        String uri = elementName.getURI();
        ExtensionElementFactory eef = ((ProfessionalConfiguration)this.config).getExtensionElementFactory(uri);
        if (eef != null) {
            String localName = elementName.getLocalPart();
            extensionClass = eef.getExtensionClass(localName);
        }
        if (extensionClass == null) {
            ElementImpl instr = super.makeElementNode(parent, elementName, elementType, isNilled, attlist, namespaces, namespacesUsed, pipe, location, sequence);
            if (instr instanceof StyleElement) {
                ((StyleElement)instr).setCompilation(this.getCompilation());
            }
            return instr;
        }
        String baseURI = null;
        int lineNumber = -1;
        int columnNumber = -1;
        baseURI = location.getSystemId();
        lineNumber = location.getLineNumber();
        columnNumber = location.getColumnNumber();
        String localname = elementName.getLocalPart();
        Class<? extends StyleElement> requiredClass = extensionClass;
        if (this.allowExtensions) {
            try {
                temp = extensionClass.newInstance();
                temp.setCompilation(this.getCompilation());
            }
            catch (IllegalAccessException | InstantiationException e1) {
                throw new IllegalStateException(e1);
            }
        } else {
            temp = new AbsentExtensionElement();
            XPathException reason = new XPathException("Extension instructions are disabled");
            temp.setValidationError(reason, 3);
            requiredClass = AbsentExtensionElement.class;
        }
        temp.setNamespaceDeclarations(namespaces, namespacesUsed);
        temp.initialise(elementName, elementType, attlist, parent, sequence);
        temp.setLocation(baseURI, lineNumber, columnNumber);
        temp.processStandardAttributes("http://www.w3.org/1999/XSL/Transform");
        if (uri.equals("http://saxon.sf.net/") && !toplevel && !temp.isExtensionNamespace("http://saxon.sf.net/")) {
            XPathException te = new XPathException("saxon:" + localname + " is not being treated as an extension instruction because the namespace  http://saxon.sf.net/ has not been declared in extension-element-prefixes", "SXWN9008", temp);
            pipe.getErrorListener().warning(te);
            requiredClass = LiteralResultElement.class;
        }
        if (requiredClass.equals(temp.getClass())) {
            node = temp;
        } else {
            try {
                node = requiredClass.newInstance();
            }
            catch (InstantiationException err1) {
                throw new TransformerFactoryConfigurationError(err1, "Failed to create instance of " + requiredClass.getName());
            }
            catch (IllegalAccessException err2) {
                throw new TransformerFactoryConfigurationError(err2, "Failed to access class " + requiredClass.getName());
            }
            node.substituteFor(temp);
        }
        return node;
    }

    @Override
    public boolean isElementAvailable(String uri, String localName, boolean instructionsOnly) {
        boolean b = super.isElementAvailable(uri, localName, instructionsOnly);
        if (b) {
            return true;
        }
        if (!this.allowExtensions) {
            return false;
        }
        ExtensionElementFactory factory = ((ProfessionalConfiguration)this.config).getExtensionElementFactory(uri);
        if (factory == null) {
            return false;
        }
        try {
            Class<? extends StyleElement> actualClass = factory.getExtensionClass(localName);
            StyleElement s = actualClass.newInstance();
            return !instructionsOnly || s.isInstruction();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public AccumulatorRegistry makeAccumulatorManager() {
        return new AccumulatorRegistry();
    }
}

