/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToStringCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.Whitespace;

public class NormalizeSpaceCompiler
extends ToStringCompiler {
    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        NormalizeSpaceCompiler.visitAnnotation(compiler, "NormalizeSpace-str");
        this.formInputString(compiler, expression, requiredClass, fnc, ga, methodInfo);
        ga.invokeStaticMethod(Whitespace.class, "collapseWhitespace", CharSequence.class);
        if (requiredClass == String.class) {
            ga.invokeInstanceMethod(CharSequence.class, "toString", new Class[0]);
        }
    }

    private void formInputString(CompilerService compiler, Expression expression, Class requiredClass, SystemFunctionCall fnc, Generator ga, GeneratedMethodInfo methodInfo) throws CannotCompileException {
        if (fnc.getArity() == 0) {
            LabelInfo nonNull = methodInfo.newLabel("nonNull");
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getContextItem", new Class[0]);
            ga.dup();
            ga.ifNonNull(nonNull.label());
            ga.pop();
            compiler.generateDynamicError("Context item for normalize-space() is absent", "XPDY0002", expression.getLocation(), false);
            methodInfo.placeLabel(nonNull);
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            if (requiredClass == String.class) {
                ga.invokeInstanceMethod(CharSequence.class, "toString", new Class[0]);
            }
        } else {
            compiler.compileToPrimitive(fnc.getArg(0), CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
            if (requiredClass == String.class) {
                ga.invokeInstanceMethod(CharSequence.class, "toString", new Class[0]);
            }
        }
    }

    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        NormalizeSpaceCompiler.visitAnnotation(compiler, "NormalizeSpace-str");
        Generator ga = compiler.getCurrentGenerator();
        this.formInputString(compiler, expression, CharSequence.class, (SystemFunctionCall)expression, ga, compiler.getCurrentMethod());
        ga.invokeStaticMethod(Whitespace.class, "isWhite", CharSequence.class);
        ga.not();
    }
}

