/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.SimpleContentFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Orphan;

public class AdjacentTextNodeMergerAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) {
        AdjacentTextNodeMerger scc = (AdjacentTextNodeMerger)this.getExpression();
        if (Streamability.getSweep(scc) == Sweep.CONSUMING) {
            Expression select = scc.getBaseExpression();
            final Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, this.getConfiguration(), null);
            if (selection != null) {
                return new WatchMaker(){

                    @Override
                    public Trigger makeWatch(WatchManager watchManager, Feed out, XPathContext context) {
                        SimpleContentFeed action = new SimpleContentFeed(out);
                        Trigger watch = new Trigger(selection, action, context);
                        watch.setPipelineConfiguration(watchManager.getPipelineConfiguration());
                        return watch;
                    }
                };
            }
            return null;
        }
        return null;
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new AdjacentTextNodeMergerFeed(this.getExpression(), out, context);
    }

    private static class AdjacentTextNodeMergerFeed
    extends ItemFeed {
        private FastStringBuffer buffer = new FastStringBuffer(100);
        boolean prevText = false;

        public AdjacentTextNodeMergerFeed(Expression exp, Feed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            this.flush();
            return this.getResult().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.flush();
            this.getResult().endSelectedParentNode(locationId);
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (AdjacentTextNodeMerger.isTextNode(item)) {
                CharSequence s = item.getStringValueCS();
                if (s.length() > 0) {
                    this.buffer.append(s);
                    this.prevText = true;
                }
            } else {
                this.flush();
                this.getResult().processItem(item);
            }
        }

        private void flush() throws XPathException {
            if (this.prevText) {
                Orphan o = new Orphan(this.getPipelineConfiguration().getConfiguration());
                o.setNodeKind((short)3);
                o.setStringValue(this.buffer.toString());
                this.getResult().processItem(o);
                this.buffer.setLength(0);
            }
            this.prevText = false;
        }

        @Override
        public void close() throws XPathException {
            this.flush();
            this.getResult().close();
        }
    }
}

