/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.openlp;

import java.util.LinkedList;
import java.util.List;
import marmot.tokenize.openlp.Aligner;
import marmot.util.LevenshteinLattice;
import marmot.util.StringUtils;

public class LevenshteinAligner
implements Aligner {
    private long timeout_ = 1000L;
    private static final String TIMEOUT_STRING = "<TIMEOUT>";
    private static final List<Character> TIMEOUT_LIST = new LinkedList<Character>();

    public LevenshteinAligner() {
        this(1000L);
    }

    public LevenshteinAligner(long timeout) {
        this.timeout_ = timeout;
    }

    @Override
    public Aligner.Result align(String input, String output) {
        SpecialLevenshteinLattice lattice = new SpecialLevenshteinLattice(input = StringUtils.clean(input), output = StringUtils.clean(output), this.timeout_);
        String operations = lattice.searchOperationSequence();
        if (operations == null) {
            return new Aligner.Result(Aligner.ResultType.NoAlignmentFound);
        }
        if (operations.equals(TIMEOUT_STRING)) {
            return new Aligner.Result(Aligner.ResultType.Timeout);
        }
        LinkedList<Aligner.Pair> pairs = new LinkedList<Aligner.Pair>();
        int input_index = 0;
        int output_index = 0;
        block6: for (int i = 0; i < operations.length(); ++i) {
            char op = operations.charAt(i);
            switch (op) {
                case 'C': {
                    pairs.add(new Aligner.Pair(input_index, output_index));
                    ++input_index;
                    ++output_index;
                    continue block6;
                }
                case 'R': {
                    pairs.add(new Aligner.Pair(input_index, output_index));
                    ++input_index;
                    ++output_index;
                    continue block6;
                }
                case 'D': {
                    if (input.charAt(input_index) == ' ') {
                        pairs.add(new Aligner.Pair(input_index, -1));
                    } else {
                        pairs.add(new Aligner.Pair(input_index, output_index));
                    }
                    ++input_index;
                    continue block6;
                }
                case 'I': {
                    if (output.charAt(output_index) == ' ') {
                        pairs.add(new Aligner.Pair(-1, output_index));
                    } else {
                        pairs.add(new Aligner.Pair(input_index, output_index));
                    }
                    ++output_index;
                }
            }
        }
        return new Aligner.Result(Aligner.ResultType.Standard, pairs);
    }

    static {
        for (int i = TIMEOUT_STRING.length() - 1; i >= 0; --i) {
            TIMEOUT_LIST.add(Character.valueOf(TIMEOUT_STRING.charAt(i)));
        }
    }

    class SpecialLevenshteinLattice
    extends LevenshteinLattice {
        private long timeout_;

        public SpecialLevenshteinLattice(String input, String output, long timeout) {
            super(input, output, 2, 2, 3);
            this.timeout_ = timeout;
        }

        @Override
        protected int getReplaceCost(char input, char output) {
            if (output == ' ' || input == ' ') {
                return 1000;
            }
            return super.getReplaceCost(input, output);
        }

        @Override
        public String searchOperationSequence() {
            this.init();
            State state = new State();
            state.input_index = this.input_.length();
            state.output_index = this.output_.length();
            state.current_path = new LinkedList<Character>();
            LinkedList<State> states = new LinkedList<State>();
            states.add(state);
            List<Character> seq = this.searchOperationSequence(states);
            if (seq == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder(seq.size());
            for (char c : seq) {
                sb.append(c);
            }
            sb.reverse();
            return sb.toString();
        }

        private List<Character> searchOperationSequence(List<State> states) {
            long time = System.currentTimeMillis();
            while (!states.isEmpty()) {
                char last_char;
                char last_op;
                List<Character> current_path;
                State state = states.remove(0);
                long current_time = System.currentTimeMillis();
                if (current_time - time > this.timeout_) {
                    return TIMEOUT_LIST;
                }
                short op = this.op_lattice_[state.input_index][state.output_index];
                if ((op & 1) > 0) {
                    assert (op == 1);
                    return state.current_path;
                }
                if ((op & 8) > 0) {
                    states.add(state.getNewState('C', -1, -1));
                }
                if ((op & 0x10) > 0) {
                    states.add(state.getNewState('R', -1, -1));
                }
                if ((op & 2) > 0) {
                    current_path = state.current_path;
                    if (this.output_.charAt(state.output_index - 1) == ' ') {
                        states.add(state.getNewState('I', 0, -1));
                    } else if (current_path.size() > 0) {
                        last_op = current_path.get(current_path.size() - 1).charValue();
                        last_char = this.output_.charAt(state.output_index);
                        if (last_op == 'I' && last_char != ' ' || last_op == 'R') {
                            states.add(state.getNewState('I', 0, -1));
                        }
                    }
                }
                if ((op & 4) <= 0) continue;
                current_path = state.current_path;
                if (this.input_.charAt(state.input_index - 1) == ' ') {
                    states.add(state.getNewState('D', -1, 0));
                    continue;
                }
                if (current_path.size() <= 0) continue;
                last_op = current_path.get(current_path.size() - 1).charValue();
                last_char = this.input_.charAt(state.input_index);
                if ((last_op != 'D' || last_char == ' ') && last_op != 'R') continue;
                states.add(state.getNewState('D', -1, 0));
            }
            return null;
        }

        class State {
            int input_index;
            int output_index;
            List<Character> current_path;

            State() {
            }

            public State getNewState(char op, int input_diff, int output_diff) {
                State state = new State();
                state.input_index = this.input_index + input_diff;
                state.output_index = this.output_index + output_diff;
                state.current_path = new LinkedList<Character>(this.current_path);
                state.current_path.add(Character.valueOf(op));
                return state;
            }
        }
    }
}

