/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.expr.QueryLibraryImpl;
import com.saxonica.expr.StaticQueryContextPE;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.QueryLibrary;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public class StaticQueryContextEE
extends StaticQueryContextPE {
    private final Map<NamespaceUri, QueryLibrary> compiledLibraries = new ConcurrentHashMap<NamespaceUri, QueryLibrary>();
    private boolean schemaAware;
    private boolean streaming;

    public StaticQueryContextEE(Configuration config) {
        super(config);
    }

    public StaticQueryContextEE(EnterpriseConfiguration config, boolean initialize) {
        super(config, initialize);
    }

    @Override
    public void copyFrom(StaticQueryContext c) {
        super.copyFrom(c);
        if (c instanceof StaticQueryContextEE) {
            this.schemaAware = ((StaticQueryContextEE)c).schemaAware;
            this.streaming = ((StaticQueryContextEE)c).streaming;
        }
    }

    @Override
    public void setSchemaAware(boolean aware) {
        if (aware) {
            this.getConfiguration().checkLicensedFeature(4, "schema-awareness", -1);
        }
        this.schemaAware = aware;
    }

    @Override
    public boolean isSchemaAware() {
        return this.schemaAware;
    }

    @Override
    public void setStreaming(boolean option) {
        this.streaming = option;
        if (option) {
            this.getConfiguration().checkLicensedFeature(4, "streaming", -1);
            this.setRequiredContextItemType(NodeKindTest.DOCUMENT);
        }
    }

    @Override
    public boolean isStreaming() {
        return this.streaming;
    }

    @Override
    public void compileLibrary(String query) throws XPathException {
        try {
            Configuration config = this.getConfiguration();
            this.getConfiguration().checkLicensedFeature(4, "separate XQuery compilation", -1);
            Executable executable = this.makeExecutable();
            FunctionLibraryList libList = new FunctionLibraryList();
            libList.addFunctionLibrary(new ExecutableFunctionLibrary(config));
            executable.setFunctionLibrary(libList);
            QueryLibraryImpl topModule = new QueryLibraryImpl(this);
            executable.setTopLevelPackage(topModule.getPackageData());
            topModule.setExecutable(executable);
            topModule.setIsMainModule(false);
            XQueryParser qp = (XQueryParser)config.newExpressionParser("XQ", this.isUpdating(), topModule);
            if (this.getCodeInjector() != null) {
                qp.setCodeInjector(this.getCodeInjector());
            }
            qp.parseLibraryModule(query, topModule);
            topModule.bindUnboundFunctionCalls();
            topModule.bindUnboundVariables();
            this.compiledLibraries.put(topModule.getModuleNamespace(), topModule);
            executable.fixupQueryModules(topModule);
            executable.addQueryLibraryModule(topModule);
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    @Override
    public void compileLibrary(Reader source) throws XPathException, IOException {
        int n;
        char[] buffer = new char[4096];
        StringBuilder sb = new StringBuilder(4096);
        while (!this.isFinished(n = source.read(buffer))) {
            sb.append(buffer, 0, n);
        }
        this.compileLibrary(sb.toString());
    }

    private boolean isFinished(int indicator) {
        return indicator < 0;
    }

    @Override
    public void compileLibrary(InputStream source, String encoding) throws XPathException, IOException {
        String query = QueryReader.readInputStream(source, encoding, this.getConfiguration().getValidCharacterChecker());
        this.compileLibrary(query);
    }

    @Override
    public QueryLibrary getCompiledLibrary(NamespaceUri namespace) {
        return this.compiledLibraries.get(namespace);
    }

    @Override
    public Iterable<QueryLibrary> getCompiledLibraries() {
        return this.compiledLibraries.values();
    }
}

