/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.s9api;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.s9api.SchemaValidatorImpl;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.ErrorReporterToListener;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.StandardErrorReporter;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.trans.XPathException;

public class SchemaManagerImpl
extends SchemaManager {
    private final Processor processor;
    private ErrorReporter errorReporter;

    public SchemaManagerImpl(Processor processor) {
        this.processor = processor;
        this.errorReporter = processor.getUnderlyingConfiguration().makeErrorReporter();
        if (this.errorReporter instanceof StandardErrorReporter) {
            ((StandardErrorReporter)this.errorReporter).setOutputErrorCodes(false);
        }
    }

    @Override
    public void setXsdVersion(String version) {
        if (!version.equals("1.0") && !version.equals("1.1")) {
            throw new IllegalArgumentException("XsdVersion");
        }
        this.processor.setConfigurationProperty(Feature.XSD_VERSION, version);
    }

    @Override
    public String getXsdVersion() {
        return this.processor.getUnderlyingConfiguration().getXsdVersion() == 10 ? "1.0" : "1.1";
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
        this.errorReporter = new ErrorReporterToListener(listener);
    }

    @Override
    public ErrorListener getErrorListener() {
        if (this.errorReporter instanceof ErrorReporterToListener) {
            return ((ErrorReporterToListener)this.errorReporter).getErrorListener();
        }
        return null;
    }

    @Override
    public void setErrorReporter(ErrorReporter reporter) {
        this.errorReporter = reporter;
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    @Override
    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        ((EnterpriseConfiguration)this.processor.getUnderlyingConfiguration()).setSchemaURIResolver(resolver);
    }

    @Override
    public SchemaURIResolver getSchemaURIResolver() {
        return ((EnterpriseConfiguration)this.processor.getUnderlyingConfiguration()).getSchemaURIResolver();
    }

    @Override
    public void load(Source source) throws SaxonApiException {
        try {
            if (source instanceof StreamSource && ((StreamSource)source).getInputStream() == null && ((StreamSource)source).getReader() == null && source.getSystemId() != null) {
                ResourceRequest request = new ResourceRequest();
                request.uri = source.getSystemId();
                request.nature = "http://www.w3.org/2001/XMLSchema";
                Source s2 = this.processor.getUnderlyingConfiguration().getResourceResolver().resolve(request);
                if (s2 != null) {
                    source = s2;
                }
            }
            this.processor.getUnderlyingConfiguration().addSchemaSource(source, this.errorReporter);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    @Override
    public void importComponents(Source source) throws SaxonApiException {
        try {
            this.processor.getUnderlyingConfiguration().importComponents(source);
        }
        catch (XPathException err) {
            throw new SaxonApiException(err);
        }
    }

    @Override
    public void exportComponents(Destination destination) throws SaxonApiException {
        try {
            Configuration config = this.processor.getUnderlyingConfiguration();
            if (config.getConfigurationProperty(Feature.ALLOW_UNRESOLVED_SCHEMA_COMPONENTS).booleanValue()) {
                throw new SaxonApiException("Exporting to an SCM file is not possible when unresolved references to schema components have been permitted");
            }
            Receiver out = destination.getReceiver(config.makePipelineConfiguration(), config.obtainDefaultSerializationProperties());
            config.exportComponents(out);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    @Override
    public SchemaValidator newSchemaValidator() {
        return new SchemaValidatorImpl(this.processor);
    }
}

