/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Cardinality;

public class ExistsCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Expression arg = fnc.getArg(0);
        ExistsCompiler.visitAnnotation(compiler, "ExistsCompiler");
        ExistsCompiler.visitLineNumber(compiler, ga, expression);
        LabelInfo returnFalse = methodInfo.newLabel("returnFalse");
        LabelInfo end = methodInfo.newLabel("endExists");
        if (Cardinality.allowsMany(arg.getCardinality())) {
            compiler.compileToIterator(arg);
            ga.dup();
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.ifNull(returnFalse.label());
            ga.invokeInstanceMethod(SequenceIterator.class, "close", new Class[0]);
            ga.push(true);
            ga.goTo(end);
            methodInfo.placeLabel(returnFalse);
            ga.pop();
            ga.push(false);
            methodInfo.placeLabel(end);
        } else {
            compiler.compileToItem(arg);
            ga.ifNull(returnFalse.label());
            ga.push(true);
            ga.goTo(end);
            methodInfo.placeLabel(returnFalse);
            ga.push(false);
            methodInfo.placeLabel(end);
        }
    }
}

