/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.SpanAttributeQuery;
import de.ids_mannheim.korap.query.SpanElementQuery;
import de.ids_mannheim.korap.query.SpanFocusQuery;
import de.ids_mannheim.korap.query.SpanTermWithIdQuery;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import de.ids_mannheim.korap.query.spans.SpansWithAttribute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class SpanWithAttributeQuery
extends SimpleSpanQuery {
    public boolean isMultipleAttributes;
    private String type;

    public SpanWithAttributeQuery(SpanAttributeQuery attributeQuery, boolean collectPayloads) {
        super(attributeQuery, collectPayloads);
        this.type = "spanWithAttribute";
    }

    public SpanWithAttributeQuery(List<SpanQuery> attributeQueries, boolean collectPayloads) {
        super(attributeQueries, collectPayloads);
        this.isMultipleAttributes = true;
        this.type = "spanWithAttribute";
    }

    public SpanWithAttributeQuery(SimpleSpanQuery firstClause, SpanAttributeQuery secondClause, boolean collectPayloads) {
        super((SpanQuery)firstClause, secondClause, collectPayloads);
        this.setType();
    }

    public SpanWithAttributeQuery(SimpleSpanQuery firstClause, List<SpanQuery> secondClauses, boolean collectPayloads) {
        super((SpanQuery)firstClause, secondClauses, collectPayloads);
        this.isMultipleAttributes = true;
        this.setType();
    }

    public String getType() {
        return this.type;
    }

    public void setType() {
        if (SpanElementQuery.class.isInstance(this.firstClause)) {
            this.type = "spanElementWithAttribute";
        } else if (SpanFocusQuery.class.isInstance(this.firstClause)) {
            this.type = "spanRelationWithAttribute";
        } else if (SpanTermWithIdQuery.class.isInstance(this.firstClause)) {
            this.type = "spanTermWithAttribute";
        }
    }

    @Override
    public SpanWithAttributeQuery clone() {
        if (this.secondClause != null) {
            if (this.isMultipleAttributes) {
                return new SpanWithAttributeQuery((SimpleSpanQuery)this.firstClause.clone(), this.cloneClauseList(), this.collectPayloads);
            }
            return new SpanWithAttributeQuery((SimpleSpanQuery)this.firstClause.clone(), (SpanAttributeQuery)this.secondClause.clone(), this.collectPayloads);
        }
        if (this.isMultipleAttributes) {
            return new SpanWithAttributeQuery(this.cloneClauseList(), this.collectPayloads);
        }
        return new SpanWithAttributeQuery((SpanAttributeQuery)this.firstClause.clone(), this.collectPayloads);
    }

    private List<SpanQuery> cloneClauseList() {
        ArrayList<SpanQuery> clauseList = new ArrayList<SpanQuery>();
        for (SpanQuery q : this.clauseList) {
            SpanAttributeQuery saq = (SpanAttributeQuery)q;
            clauseList.add(saq.clone());
        }
        return clauseList;
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        if (this.type.equals("spanWithAttribute")) {
            return new SpansWithAttribute(this, context, acceptDocs, termContexts);
        }
        SimpleSpans spans = (SimpleSpans)this.getFirstClause().getSpans(context, acceptDocs, termContexts);
        return new SpansWithAttribute(this, spans, context, acceptDocs, termContexts);
    }

    @Override
    public String toString(String field) {
        boolean isFirstClassNull = true;
        StringBuilder sb = new StringBuilder();
        sb.append(this.type);
        sb.append("(");
        if (this.firstClause != null) {
            sb.append(this.firstClause.toString(field));
            isFirstClassNull = false;
        }
        if (this.secondClause != null) {
            sb.append(", ");
            sb.append(this.secondClause.toString(field));
        } else if (this.isMultipleAttributes) {
            if (!isFirstClassNull) {
                sb.append(", ");
            }
            sb.append("[");
            for (int i = 0; i < this.clauseList.size(); ++i) {
                SpanQuery sq = (SpanQuery)this.clauseList.get(i);
                sb.append(sq.toString(field));
                if (i >= this.clauseList.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }
}

