/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.pedigree;

import com.saxonica.xsltextn.pedigree.PedigreeArrayItem;
import com.saxonica.xsltextn.pedigree.PedigreeMapItem;
import com.saxonica.xsltextn.pedigree.PedigreeValue;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.value.AtomicValue;

public class Pedigree {
    private final PedigreeValue container;
    private int index = -1;
    private AtomicValue key;
    public static final Pedigree PEDIGREE_ROOT = new Pedigree(null, null);

    public Pedigree(PedigreeValue container, AtomicValue key) {
        this.container = container;
        this.key = key;
    }

    public Pedigree(PedigreeValue container, int index) {
        this.container = container;
        this.index = index;
    }

    public PedigreeValue getContainer() {
        return this.container;
    }

    public int getIndex() {
        return this.index;
    }

    public AtomicValue getKey() {
        return this.key;
    }

    public GroundedValue makePedigreeValue(GroundedValue value) {
        if (value instanceof PedigreeArrayItem) {
            return new PedigreeArrayItem(((PedigreeArrayItem)value).getBaseItem(), this);
        }
        if (value instanceof PedigreeMapItem) {
            return new PedigreeMapItem(((PedigreeMapItem)value).getBaseItem(), this);
        }
        if (value instanceof ArrayItem) {
            return new PedigreeArrayItem((ArrayItem)value, this);
        }
        if (value instanceof MapItem) {
            return new PedigreeMapItem((MapItem)value, this);
        }
        return value;
    }
}

