/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import java.util.StringTokenizer;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.SchemaException;

public class XSDUnion
extends SchemaElement {
    private SimpleTypeDefinition typeDefinition;
    private int numberOfMemberTypes = 0;

    @Override
    protected void prepareAttributes() throws SchemaException {
        this.typeDefinition = this.getContainingSimpleType();
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"id", "memberTypes"};
        this.allowAttributes(atts, allowed);
        this.processId();
        this.typeDefinition.setDerivationMethodName("union");
        String memberTypes = atts.getValue(NamespaceUri.NULL, "memberTypes");
        this.processMemberTypes(memberTypes);
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        boolean foundAnnotation = false;
        boolean foundSimpleType = false;
        for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            if (fp == 578) {
                if (foundAnnotation) {
                    this.duplicateElement("annotation");
                }
                if (foundSimpleType) {
                    this.mustBeFirstElement("annotation");
                }
                foundAnnotation = true;
                continue;
            }
            if (fp == 621) {
                foundSimpleType = true;
                ++this.numberOfMemberTypes;
                continue;
            }
            this.illegalElement(nodeInfo);
        }
        if (this.numberOfMemberTypes == 0) {
            String err = "A union type must have at least one member type";
            this.error(err);
        }
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        for (NodeInfo nodeInfo : this.children()) {
            if (nodeInfo.getFingerprint() != 621) continue;
            SimpleTypeDefinition memberType = ((XSDSimpleType)nodeInfo).getSimpleTypeDefinition();
            int fp = ((XSDSimpleType)nodeInfo).getSimpleTypeDefinition().getFingerprint();
            TypeReference ref = new TypeReference(fp, compiler.getConfiguration(), nodeInfo);
            ref.setTarget(memberType);
            this.typeDefinition.addMemberType(ref);
        }
    }

    private void processMemberTypes(String memberTypes) throws SchemaException {
        if (memberTypes == null || memberTypes.isEmpty()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(memberTypes, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            int fp;
            String typeName = st.nextToken();
            try {
                fp = this.getFingerprint(typeName, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            if (fp == 634 || fp == 633) {
                if (this.getConfiguration().getXsdVersion() == 10) {
                    this.warning("Type " + typeName + " is recognized by Saxon but is not interoperable");
                }
            } else if (fp == 573 || fp == 632 || fp == 631 || fp == 630) {
                if (this.getConfiguration().getXsdVersion() == 10) {
                    this.warning("In XSD 1.1, type " + typeName + " cannot be used as a member type of a union");
                } else {
                    this.error("In XSD 1.1, type " + typeName + " cannot be used as a member type of a union");
                }
            }
            TypeReference ref = new TypeReference(fp, this.typeDefinition.getConfiguration(), this);
            this.typeDefinition.addMemberType(ref);
            ++this.numberOfMemberTypes;
        }
    }
}

